package ru.yandex.calendar.util.db;

import javax.sql.DataSource;

import io.micrometer.core.instrument.MeterRegistry;

import ru.yandex.misc.db.pool.PooledDataSourceFactorySupport;
import ru.yandex.misc.db.pool.dbcp.DbcpConfiguration;

public class DataSourceFactoryWithMetrics extends PooledDataSourceFactorySupport<DbcpConfiguration> {
    private final MeterRegistry registry;

    public DataSourceFactoryWithMetrics(MeterRegistry registry) {
        this.registry = registry;
    }

    protected DbcpConfiguration defaultPoolConfiguration() {
        return new DbcpConfiguration();
    }

    protected DataSource createDataSource(String url, String username, String password, DbcpConfiguration conf) {
        return new DataSourceWithMetrics(url, username, password, conf, registry);
    }
}
