package ru.yandex.calendar.util.db;

import java.sql.Connection;

import javax.sql.DataSource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.alive2.location.Location;
import ru.yandex.commune.alive2.location.LocationResolver;
import ru.yandex.misc.db.masterSlave.dynamic.DynamicMasterSlaveDataSource;
import ru.yandex.misc.db.masterSlave.dynamic.DynamicMasterSlaveDataSourceFactoryBean;
import ru.yandex.misc.db.url.JdbcUrl;
import ru.yandex.misc.io.IoFunction;


/**
 * @author dbrylev
 */
public class DcAwareDynamicMasterSlaveDataSourceFactoryBean extends DynamicMasterSlaveDataSourceFactoryBean {

    @Autowired
    private LocationResolver locationResolver;
    @Value("${calendar.jdbc.replicationMaxLag:-10}")
    private int replicationMaxLag;
    @Value("${calendar.jdbc.pingDelay:-1000}")
    private int pingDelay;

    @Override
    protected ListF<String> sortHosts(ListF<String> urls) {
        Location myLocation = locationResolver.resolveLocation();

        return urls.sortedByDesc(url -> locationResolver.resolveLocationFor(
                Option.of(JdbcUrl.valueOf(url).getHost().get())).dcName.isMatch(myLocation.getDcName()::isSome));
    }

    @Override
    protected DynamicMasterSlaveDataSource createDynamicMasterSlaveDataSource(
            ListF<DataSource> datasources, DynamicMasterSlaveDataSource.Options options, IoFunction<Connection, Connection> connectionHandler)
    {
        DcAwareDynamicMasterSlaveDataSource.Options opts = new DcAwareDynamicMasterSlaveDataSource.Options(
                options.isQuietMode(), options.isCheckSlavesReadOnly(), replicationMaxLag, pingDelay);

        return new DcAwareDynamicMasterSlaveDataSource(
                datasources, new LoggingQueryInterceptor(), opts);
    }
}
