package ru.yandex.calendar.util.db;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;

import io.micrometer.core.instrument.MeterRegistry;
import org.springframework.jdbc.datasource.DriverManagerDataSource;

public class DriverManagerDataSourceWithMetrics extends DriverManagerDataSource {
    private final MeterRegistry registry;

    DriverManagerDataSourceWithMetrics(String url, String username, String password, MeterRegistry registry) {
        super(url, username, password);
        this.registry = registry;
    }

    @Override
    protected Connection getConnectionFromDriverManager(String url, Properties props) throws SQLException {
        return new ConnectionWithMetrics(super.getConnectionFromDriverManager(url, props), registry);
    }

    @Override
    public String toString() {
        return getUrl();
    }
}
