package ru.yandex.calendar.util.db;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.misc.db.q.SqlPart;

/**
 * @author yashunsky
 */
public class FieldsAssignment extends SqlPart {
    private final ListF<String> columns;
    private final ListF<Object> values;

    public FieldsAssignment(Tuple2List<String, Object> columnsWithValues) {
        this.columns = columnsWithValues.get1();
        this.values = columnsWithValues.get2();
    }

    @Override
    public ListF<Object> args() {
        return values;
    }

    @Override
    public String sql(Option<String> tableName) {
        String tablePrefix = tableName.map(s -> s + ".").getOrElse("");
        return columns.map(s -> s + " = ?").map(s -> s + tablePrefix).mkString(", ");
    }
}
