package ru.yandex.calendar.util.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import io.micrometer.core.instrument.MeterRegistry;
import lombok.SneakyThrows;
import lombok.experimental.Delegate;

public class PreparedStatementWithMetrics extends StatementWithMetrics implements PreparedStatement {
    private final String query;
    @Delegate(excludes = StatementExecuteMethodsInterface.class)
    private final PreparedStatement target;

    PreparedStatementWithMetrics(Connection owner, PreparedStatement target, String query,
            MeterRegistry registry) {
        super(owner, target, registry);
        this.target = target;
        this.query = query;
    }

    @Override
    @SneakyThrows
    public ResultSet executeQuery() {
        return executeWithMetrics(target::executeQuery);
    }

    @Override
    @SneakyThrows
    public int executeUpdate() {
        return executeWithMetrics(target::executeUpdate);
    }

    @Override
    @SneakyThrows
    public boolean execute() throws SQLException {
        return executeWithMetrics(target::execute);
    }

    @Override
    @SneakyThrows
    public long executeLargeUpdate() {
        return executeWithMetrics(target::executeLargeUpdate);
    }
}
