package ru.yandex.calendar.util.db;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.db.q.SqlExpression;

/**
 * @author dbrylev
 */
public class SqlFunction extends SqlExpression {
    private final String function;
    private final SqlExpression expression;

    private SqlFunction(String function, SqlExpression expression) {
        this.function = function;
        this.expression = expression;
    }

    @Override
    public ListF<Object> args() {
        return expression.args();
    }

    @Override
    public String sql(Option<String> tableName) {
        return function + "(" + expression.sql(tableName) + ")";
    }

    public static SqlFunction lower(SqlExpression expression) {
        return new SqlFunction("LOWER", expression);
    }

    public static SqlFunction count(SqlExpression expression) {
        return new SqlFunction("COUNT", expression);
    }
}
