package ru.yandex.calendar.util.db;

import org.springframework.test.context.TestContext;
import org.springframework.test.context.support.AbstractTestExecutionListener;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

import ru.yandex.misc.lang.Check;

/**
 * @author tolmalev
 */
public class TransactionForEachTestMethodCreator extends AbstractTestExecutionListener {

    private TransactionStatus status;

    @Override
    public void beforeTestMethod(TestContext testContext) throws Exception {
        status = getTransactionManager(testContext)
                .getTransaction(new DefaultTransactionDefinition());
        Check.notNull(status, "TransactionStatus");
    }

    @Override
    public void afterTestMethod(TestContext testContext) throws Exception {
        getTransactionManager(testContext).rollback(status);
    }

    protected final PlatformTransactionManager getTransactionManager(TestContext testContext) {
        return testContext.getApplicationContext()
                .getBean("transactionManager", PlatformTransactionManager.class);
    }
}
