package ru.yandex.calendar.util.exception;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function0;
import ru.yandex.misc.lang.Validate;
import ru.yandex.misc.reflection.ClassX;
import ru.yandex.misc.thread.ThreadLocalTimeoutException;

/**
 * @author Daniel Brylev <dbrylev@yandex-team.ru>
 */
public class ExceptionUtils extends ru.yandex.misc.ExceptionUtils {

    private static final ListF<ClassX<? extends Throwable>> REFLECTION_WRAPPERS =
            Cf.list(
                    java.lang.reflect.InvocationTargetException.class,
                    ru.yandex.misc.reflection.ReflectionException.class,
                    ru.yandex.bolts.internal.ReflectionException.class
            ).map(ClassX.<Throwable>wrapExtendsF());

    public static Throwable unwrapReflection(Throwable reflectionThrowable) {
        Validate.notNull(reflectionThrowable);
        Throwable cur = reflectionThrowable;

        while (cur.getCause() != null && REFLECTION_WRAPPERS.exists(ClassX.getClass(cur)::isAssignableTo)) {
            cur = cur.getCause();
        }
        return cur;
    }

    public static <T extends Throwable> Option<T> unwrap(Throwable throwable, Class<T> clazz) {
        while (throwable != null) {
            if (clazz.isInstance(throwable)) {
                return Option.of(throwable).cast();
            }
            throwable = throwable.getCause();
        }
        return Option.empty();
    }

    public static void rethrowIfTlt(Exception e) {
        if (e instanceof ThreadLocalTimeoutException) {
            throw (ThreadLocalTimeoutException) e;
        }
    }

    public static <T> T executeOrThrow(Function0<T> execution, String message) {
        try {
            return execution.apply();
        } catch (RuntimeException e) {
            throw new RuntimeException(message + ": " + ru.yandex.misc.ExceptionUtils.getAllMessages(e), e);
        }
    }
}
