package ru.yandex.calendar.util.html;

import java.io.IOException;
import java.io.StringReader;

import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;

import ru.yandex.misc.io.IoUtils;
import ru.yandex.misc.lang.StringUtils;

/**
 * @author gutman
 */
public class HtmlUtils {
    public static String html2text(String html) {
        try {
            StringBuffer buff = new StringBuffer();
            new ParserDelegator().parse(new StringReader(html), writeTextTo(buff), true);
            return StringUtils.strip(buff.toString());
        } catch (IOException e) {
            throw IoUtils.translate(e);
        }
    }

    private static HTMLEditorKit.ParserCallback writeTextTo(final StringBuffer buff) {
        return new HTMLEditorKit.ParserCallback() {
            private boolean inHead = false;
            public void handleText(char[] data, int pos) {
                if (!inHead) {
                    buff.append(data).append(" ");
                }
            }
            public void handleStartTag(HTML.Tag t, MutableAttributeSet a, int pos) {
                if (t.equals(HTML.Tag.HEAD)) inHead = true;
            }
            public void handleEndTag(HTML.Tag t, int pos) {
                if (t.equals(HTML.Tag.HEAD)) inHead = false;
            }
        };
    }
}
