package ru.yandex.calendar.util.idlent;

import Yandex.RequestPackage.ParamValue;
import Yandex.RequestPackage.RequestData;
import org.jdom.Element;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.calendar.util.data.AliasedDataProvider;
import ru.yandex.misc.lang.StringUtils;
import ru.yandex.misc.xml.jdom.JdomUtils;

/**
 * Creates fake {@link Yandex.RequestPackage.RequestData} objects
 * @author ssytnik
 */
public class RequestDataFactory {
    public static RequestData create() { return createInner(); }

    // No encodings, no '=' and '&' signs are supported for easiness.
    // Since this ctor is just for testing purposes, it's no problem.
    public static RequestData create(String query) {
        ListF<ParamValue> paramList = Cf.arrayList();
        if (StringUtils.isNotEmpty(query)) {
            ListF<String> pairs = Cf.list(query.split("\\&"));
            for (String pair : pairs) {
                String[] pairArr = pair.split("=");
                if (pairArr.length > 0) {
                    // No tricks here. Empty parameters should be added as empty parameters, not nulls.
                    String name = pairArr[0];
                    String value = (pairArr.length > 1 ? pairArr[1] : "");
                    ParamValue param = new ParamValue(name, value);
                    paramList.add(param);
                }
            }
        }
        return createInner(query, paramList.toArray(new ParamValue[paramList.size()]));
    }

//    public static RequestData create(ParamValue... paramValues) {
//        return createInner(AuxBase.EMPTY_STR, paramValues);
//    }

    // Testing subroutines
    public static RequestData createFromXml(String xml, boolean isAliased) {
        return createFromXml(JdomUtils.I.readRootElement(xml), isAliased);
    }
    public static RequestData createFromXml(byte[] xml, boolean isAliased) {
        return createFromXml(JdomUtils.I.readRootElement(xml), isAliased);
    }
    public static RequestData createFromXml(Element eRoot, boolean isAliased) {
        RequestData res = createInner();
        final ListF<ParamValue> pvList = addParams(Cf.<ParamValue>arrayList(), eRoot, "", isAliased);
        res.queryArgs = pvList.toArray(new ParamValue[0]);
        return res;
    }

    // PRIVATE //

    // Xml element should not contain mixed content - either text or nested elements.
    // Empty elements treated as elements with no children, not as empty text elements.
    private static ListF<ParamValue> addParams(
            ListF<ParamValue> paramList, Element e, String fullName, boolean isAliased) {

        if (StringUtils.isNotEmpty(e.getTextNormalize())) {
            if (StringUtils.isNotEmpty(fullName)) { // do not add root element (however, it should not have text)
                paramList.add(new ParamValue(fullName, e.getText()));
            }
        } else {
            if (StringUtils.isNotEmpty(fullName)) {
                paramList.add(new ParamValue(fullName, "1"));
            }
            for (Object childElmObj : e.getChildren()) {
                Element childElm = (Element) childElmObj;
                final String fixedName = AliasedDataProvider.getFixedName(childElm.getName());
                final String newFullName =
                    fullName + (StringUtils.isNotEmpty(fullName) ? "_" : "") +
                    (isAliased ? AliasedDataProvider.getAlias(fixedName) : fixedName);
                addParams(paramList, childElm, newFullName, isAliased);
            }
        }
        return paramList;
    }

    private static RequestData createInner() {
        return createInner("", new ParamValue[] {});
    }
    private static RequestData createInner(String query, ParamValue[] queryArgs) {
        return new RequestData(
            "127.0.0.1", "fake_localhost", query, queryArgs,
            new ParamValue[] {}, new ParamValue[] {}
        );
    }
} // class
