package ru.yandex.calendar.util.idlent;

import java.util.LinkedHashSet;

import Yandex.Request;
import Yandex.RequestPackage.FileNotExist;
import Yandex.RequestPackage.ParamValue;
import Yandex.RequestPackage.RequestData;
import Yandex.RequestPackage.RequestFinished;
import org.jdom.Element;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.calendar.frontend.web.cmd.run.CommandRunException;
import ru.yandex.calendar.util.CharsetUtils;
import ru.yandex.calendar.util.base.AuxColl;
import ru.yandex.calendar.util.xml.CalendarXmlizer;
import ru.yandex.misc.lang.StringUtils;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * Convenient wrapper over the given request data that can be used for
 * getting typed parameters with safe / unsafe / nullable conversions.
 * It can also append itself to a given XML element.
 *
 * @author ssytnik
 */
public class RequestWrapper {
    private static final Logger logger = LoggerFactory.getLogger(RequestWrapper.class);
    private static final String REQUEST_PARAMS_TAG_NAME = "request-parameters";
    //private static final String REQUEST_CLASS_TAG_NAME = "request-class";
    //public static final Request NULL_REQUEST = null;

    private final Yandex.RequestPackage.ParamValue[] params;
    private SetF<String> keySet = Cf.x(new LinkedHashSet<String>());
    private MapF<String, String> paramsMap = Cf.hashMap();
    private MapF<String, ListF<String>> multiParamsMap = Cf.hashMap();
    //private final String className;

    public RequestWrapper(RequestData requestData) {
        params = requestData.queryArgs;
        for (ParamValue param : params) {
            String key = param.Param;
            String value = param.Value;
            if (value != null /*&& AuxBase.isSet(value.trim())*/) { // accept empty strings
                add(key, value.trim());
            }
        }
        //className = requestData.getClass().getName().getOrNull();
    }

    private void add(String key, String value) {
        keySet.add(key);
        // if parameter already in multimap (2+ values), add it to multi-params map
        if (multiParamsMap.containsKeyTs(key)) {
            ListF<String> arr = multiParamsMap.getTs(key);
            arr.add(value);
        } else {
            // otherwise, see whether it is first or 2nd value of a parameter
            if (paramsMap.containsKeyTs(key)) {
                ListF<String> arr = Cf.arrayList();
                arr.add(paramsMap.getTs(key));
                arr.add(value);
                paramsMap.removeTs(key);
                multiParamsMap.put(key, arr);
            } else {
                paramsMap.put(key, value);
            }
        }
    }

    // Returns parameter names
    public SetF<String> getNames() {
        return keySet;
    }

    // Returns params
    public ParamValue[] getParamsArray() {
        return params;
    }

    // Accessors

    // Accessor is safe when silent after unsuccessful conversion to a type.
    // Can return null if does not replace null parameter with a default value.
    // Unsafe and nullable accessors are marked correspondingly.

     //Can return null (or, if forceNull is false, empty string)
    public String getNullableString(String key, boolean forceNull) {
        String res;
        if (multiParamsMap.containsKeyTs(key)) {
            ListF<String> arr = multiParamsMap.getTs(key);
            res = arr.get(0);
        } else {
            res = paramsMap.getTs(key);
        }
        return (forceNull ? StringUtils.defaultIfEmpty(res, null) : res);
    }

//    public String getNullableString(String key) {
//        // NOTE: ssytnik: 2010-06-02 experimental.
//        // Should always work as we cannot rely on
//        // makeup in distinguishing between cases:
//        // 'absent' parameter / 'empty'  parameter.
//        // UPD: won't work well on param collections
//        // with blanks in the middle. So, instead, we
//        // are now using getNullableString(key, true)
//        // for texts and getNullableString(key, false)
//        // for another data providers
//        return getNullableString(key, true);
//    }

//    public String getString(String key) {
//        return AuxBase.fNonNull(getNullableString(key));
//    }

//    public Binary getBinary(String key) {
//        return AuxBase.toBinary(getNullableString(key));
//    }
//
//    // Unsafe, can return null.
//    public Boolean getNullableBooleanUnsafe(String key) {
//        return AuxBase.toNullableBooleanUnsafe(getNullableString(key));
//    }
//
//    // Safe - does not throw exceptions. Can return null.
//    public Boolean getNullableBoolean(String key) {
//        return AuxBase.toNullableBoolean(getNullableString(key));
//    }
//
//    // Safe - does not throw exceptions
//    public Boolean getBoolean(String key) {
//        return AuxBase.toBoolean(getNullableString(key)); // autoboxed
//    }
//
//    // Unsafe, can return null.
//    public Short getNullableShortUnsafe(String key) {
//        return AuxBase.toNullableShortUnsafe(getNullableString(key));
//    }
//
//    // Safe - does not throw exceptions. Can return null.
//    public Short getNullableShort(String key) {
//        return AuxBase.toNullableShort(getNullableString(key));
//    }
//
//    // Safe - does not throw exceptions
//    public Short getShort(String key) {
//        return AuxBase.toShort(getNullableString(key)); // autoboxed
//    }
//
//    // Unsafe, can return null.
//    public Integer getNullableIntUnsafe(String key) {
//        return AuxBase.toNullableIntUnsafe(getNullableString(key));
//    }
//
//    // Safe - does not throw exceptions. Can return null.
//    public Integer getNullableInt(String key) {
//        return AuxBase.toNullableInt(getNullableString(key));
//    }
//
//    // Safe - does not throw exceptions
//    public Integer getInt(String key) {
//        return AuxBase.toInt(getNullableString(key)); // autoboxed
//    }
//
//    // Unsafe, can return null.
//    public Long getNullableLongUnsafe(String key) {
//        return AuxBase.toNullableLongUnsafe(getNullableString(key));
//    }
//
//    // Safe - does not throw exceptions. Can return null.
//    public Long getNullableLong(String key) {
//        return AuxBase.toNullableLong(getNullableString(key));
//    }
//
//    // Safe - does not throw exceptions
//    public Long getLong(String key) {
//        return AuxBase.toLong(getNullableString(key)); // autoboxed
//    }
//
//    // Unsafe, can return null.
//    public Time getNullableTimeUnsafe(String key, DateTimeFormatter dtf) {
//        return dtf.toNullableTimeUnsafe(getNullableString(key));
//    }
//
//    // Safe - does not throw exceptions. Can return null.
//    public Time getNullableTime(String key, DateTimeFormatter dtf) {
//        return dtf.toNullableTime(getNullableString(key));
//    }
//
//    // Safe - does not throw exceptions
//    public Time getTime(String key, Time defaultValue, DateTimeFormatter dtf) {
//        return dtf.toTime(getNullableString(key), defaultValue);
//    }
//
//    // Unsafe, can return null.
//    public java.sql.Date getNullableDateUnsafe(String key, DateTimeFormatter dtf) {
//        return dtf.toNullableDateUnsafe(getNullableString(key));
//    }
//
//    // Safe - does not throw exceptions. Can return null.
//    public java.sql.Date getNullableDate(String key, DateTimeFormatter dtf) {
//        return dtf.toNullableDate(getNullableString(key));
//    }
//
//    // Safe - does not throw exceptions
//    public java.sql.Date getDate(String key, java.sql.Date defaultValue, DateTimeFormatter dtf) {
//        return dtf.toDate(getNullableString(key), defaultValue);
//    }
//
//    // Unsafe, can return null.
//    public Timestamp getNullableTimestampUnsafe(String key, DateTimeFormatter dtf) {
//        return dtf.toNullableTimestampUnsafe(getNullableString(key));
//    }
//
//    // Safe - does not throw exceptions. Can return null.
//    public Timestamp getNullableTimestamp(String key, DateTimeFormatter dtf) {
//        return dtf.toNullableTimestamp(getNullableString(key));
//    }
//
//    // Safe - does not throw exceptions
//    public Timestamp getTimestamp(String key, Timestamp defaultValue, DateTimeFormatter dtf) {
//        return dtf.toTimestamp(getNullableString(key), defaultValue);
//    }

    // Does not contain nulls in array, can contain empty strings
    public String[] getArray(String key) {
        final String[] res;
        if (multiParamsMap.containsKeyTs(key)) {
            ListF<String> arr = multiParamsMap.getTs(key); // does not contain nulls
            res = arr.toArray(new String[] {});
        } else {
            String value = paramsMap.getTs(key);
            res = new String[] { (value != null ? value : "") };
        }
        return res;
    }

    // Logs all request parameters
    public void logRequest() {
        logger.debug(toString());
    }

    public void addXmlElementTo(Element xmlElement) {
        Element eParams = new Element(REQUEST_PARAMS_TAG_NAME);
        for (ParamValue param : params) {
            if (StringUtils.isNotEmpty(param.Param) && !param.Param.startsWith("_")) { // CAL-6215
                CalendarXmlizer.appendElm(eParams, param.Param, param.Value);
            }
        }
        xmlElement.addContent(eParams);
        //XmlUtils.appendElm(xmlElement, REQUEST_CLASS_TAG_NAME, className);
    }

    public String toString() { return "Parameters: " + AuxColl.toString(params); }

    // Can accept null
    public static RequestData getRequestDataSilent(Request request) {
        if (request == null) {
            logger.debug("RW.getRequestDataSilent(): request == null");
            return null;
        }
        try { return request.getRequestData(); }
        catch (RequestFinished e) {
            logger.error("RW.getRequestDataSilent(): could not get request data", e);
            return null;
        }
    }

    // Remote POST contents related

//    public static String getRemoteFileString(Request request, String name) {
//        return getRemoteFileString(request, AuxBase.UTF8, name);
//    }

//    public static String getRemoteFileString(Request request, String encoding, String name)
//            {
//        //
//        final byte[] bytes = getRemoteFile(request, name); // can be null
//        return AuxBase.bytesToString(bytes, encoding, "RequestWrapper.getRemoteFileString()");
//    }

    // Can accept nulls. Can return null.
    public static byte[] getRemoteFile(Request request, String name) {
        final String prefix = "RequestWrapper.getRemoteFile(): ";
        if (request == null) {
            logger.debug(prefix + "request == null");
            return null;
        }
        if (StringUtils.isEmpty(name)) {
            logger.debug(prefix + "file name is not set");
            return null;
        }
        try {
            byte[] res = request.getRemoteFile(name);
            logger.debug(res == null ?
                prefix + "request.getRemoteFile() returned null" :
                prefix + "(" + res.length + " byte(s) received for file '" + name + "')"
            );
            return res;
        } catch (RequestFinished e) {
            final String msg = prefix + "could not get file '" + name + "'";
            //logger.error(msg, e);
            //return null;
            throw new CommandRunException(msg);
        } catch (FileNotExist e) {
            final String msg = prefix + "file '" + name + "' was not given";
            logger.debug(msg);
            return null; // normal situation, file not uploaded
        }
    }

    // Does not check errors so precisely as getRemoteFile() does that
    public static String getRemoteFilename(Request request, String name) {
        try { return CharsetUtils.fromAscii(request.getRemoteFilename(name)); }
        catch (org.omg.CORBA.UserException e) { return null; }
    }

    // Does not check errors so precisely as getRemoteFile() does that
    public static String getRemoteFiletype(Request request, String name) {
        try { return request.getRemoteFiletype(name); }
        catch (org.omg.CORBA.UserException e) { return null; }
    }
}
