package ru.yandex.calendar.util.idlent;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.calendar.logic.user.Language;
import ru.yandex.calendar.util.email.Emails;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.inside.passport.blackbox2.protocol.response.Karma;
import ru.yandex.inside.passport.login.PassportLogin;
import ru.yandex.misc.email.Email;
import ru.yandex.misc.lang.DefaultObject;
import ru.yandex.misc.lang.Validate;

/**
 * Gathers all operations related to yandex user
 * (uid, login, email, basic personal information).
 * @author ssytnik
 */
public class YandexUser extends DefaultObject {
    private final PassportUid uid;
    private final PassportLogin login;
    private final Option<String> name;
    private final Option<Email> email;
    private final Option<String> domain;
    private final Option<Karma> karma;
    private final Option<Language> language;

    public YandexUser(
            PassportUid uid, PassportLogin login, Option<String> name,
            Option<Email> email, Option<String> domain, Option<Karma> karma, Option<Language> language)
    {
        Validate.notNull(login);
        Validate.notNull(uid);
        this.uid = uid;
        this.login = login;
        this.name = name;
        this.email = email;
        this.domain = domain;
        this.karma = karma;
        this.language = language;
    }

    public PassportUid getUid()   { return uid; }
    public PassportLogin getLogin() { return login; }
    public Option<String> getName()  { return name; }
    public Option<Email> getEmail() { return email; }
    public Option<String> getDomain() { return domain; }
    public Option<Karma> getKarma() { return karma; }
    public Option<Language> getLanguage() { return language; }

    public Option<String> getUnicodedEmail() {
        return email.map(Emails::getUnicoded);
    }

    public YandexUser withEmail(Email email) {
        return new YandexUser(uid, login, name, Option.of(email), domain, karma, language);
    }

    public static Function<YandexUser, PassportUid> getUidF() {
        return a -> a.uid;
    }

    public static Function<YandexUser, Option<Email>> getEmailF() {
        return a -> a.email;
    }

    public static Function<YandexUser, PassportLogin> getLoginF() {
        return a -> a.login;
    }
}
