package ru.yandex.calendar.util.json;

import java.math.BigDecimal;

import ru.yandex.commune.json.write.JsonWriter;
import ru.yandex.misc.bender.serialize.BenderJsonWriter;

/**
 * @author dbrylev
 */
public class BendableJsonWriter implements BenderJsonWriter {

    private final JsonWriter w;

    public BendableJsonWriter(JsonWriter w) {
        this.w = w;
    }

    @Override
    public void writeObjectStart() {
        w.writeObjectStart();
    }

    @Override
    public void writeObjectEnd() {
        w.writeObjectEnd();
    }

    @Override
    public void writeFieldName(String name) {
        w.writeFieldName(name);
    }

    @Override
    public void writeArrayStart() {
        w.writeArrayStart();
    }

    @Override
    public void writeArrayEnd() {
        w.writeArrayEnd();
    }

    @Override
    public void writeString(String value) {
        w.writeString(value);
    }

    @Override
    public void writeNumber(int value) {
        w.writeNumber(value);
    }

    @Override
    public void writeNumber(long value) {
        w.writeNumber(value);
    }

    @Override
    public void writeNumber(double value) {
        w.writeNumber(value);
    }

    @Override
    public void writeNumber(float value) {
        w.writeNumber(value);
    }

    @Override
    public void writeNumber(BigDecimal value) {
        w.writeNumber(value);
    }

    @Override
    public void writeBoolean(boolean value) {
        w.writeBoolean(value);
    }

    @Override
    public void writeNull() {
        w.writeNull();
    }

    @Override
    public void flush() {
        w.flush();
    }

    @Override
    public void close() {
        w.close();
    }
}
