package ru.yandex.calendar.util.net;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.net.HostnameUtils;

/**
 * @author ssytnik
 */
public class CalendarHostnameUtils {
    private static final Pattern HOST_ID_PATTERN =
            Pattern.compile("^[a-z-_]+(\\d+[a-z]?)(?:\\.|$)", Pattern.CASE_INSENSITIVE);

    public static Option<String> getLocalhostId() {
        return getHostId(HostnameUtils.localHostname());
    }

    public static Option<String> getHostId(String hostname) {
        Matcher m = HOST_ID_PATTERN.matcher(hostname);
        return m.find() ? Option.of(m.group(1)) : Option.<String>empty();
    }

}
