package ru.yandex.calendar.util.resources;

import java.io.InputStream;

import javax.xml.transform.stream.StreamSource;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.calendar.logic.user.Language;
import ru.yandex.misc.io.InputStreamSource;
import ru.yandex.misc.io.RuntimeIoException;
import ru.yandex.misc.io.SimpleInputStreamSource;
import ru.yandex.misc.lang.Validate;

/**
 * Provides access to resources
 * @author ssytnik
 */
public class CalendarClassPathResourceUtils {
    // Common stuff for resource names
    // (directories)
    private static final String ROOT_RES_DIR = "/";

    // Final resource names
    public static enum ResourceName {
        EMAIL_EVENT_CANCEL_XSL("email-xslts/event-cancel.xsl"),
        EMAIL_EVENT_INVITATION_XSL("email-xslts/event-invitation.xsl"),
        EMAIL_EVENT_NOTIFICATION_XSL("email-xslts/event-notification.xsl"),
        EMAIL_EVENT_REPLY_XSL("email-xslts/event-reply.xsl"),
        EMAIL_EVENT_UPDATE_XSL("email-xslts/event-update.xsl"),
        EMAIL_EVENT_REORGANIZATION("email-xslts/event-reorganization.xsl"),
        EMAIL_LAYER_INVITATION_XSL("email-xslts/layer-invitation.xsl"),
        EMAIL_TODO_LIST_XSL("email-xslts/todo-list.xsl"),
        EMAIL_TODO_NOTIFICATION_XSL("email-xslts/todo-notification.xsl"),
        EMAIL_REPETITION_CONFIRMATION_XSL("email-xslts/repetition-confirmation.xsl"),
        EMAIL_APARTMENT_INVITATION_XSL("email-xslts/apartment-invitation.xsl"),
        EMAIL_APARTMENT_UPDATE_XSL("email-xslts/apartment-update.xsl"),
        EMAIL_APARTMENT_CANCEL_XSL("email-xslts/apartment-cancel.xsl"),
        EMAIL_EVENT_LAYER_ADDED_XSL("email-xslts/event-layer-added.xsl"),
        EMAIL_EVENT_LAYER_UPDATED_XSL("email-xslts/event-layer-updated.xsl"),
        EMAIL_EVENT_LAYER_REMOVED_XSL("email-xslts/event-layer-removed.xsl"),
        EMAIL_EVENT_RESOURCE_ADDED_XSL("email-xslts/event-resource-added.xsl"),
        EMAIL_EVENT_RESOURCE_UPDATED_XSL("email-xslts/event-resource-updated.xsl"),
        EMAIL_EVENT_RESOURCE_REMOVED_XSL("email-xslts/event-resource-removed.xsl"),
        EMAIL_BROKEN_DISPLAY_XSL("email-xslts/broken-display.xsl"),
        EMAIL_CAMPUS_XSL("email-xslts/campus.xsl"),
        EMAIL_HOTEL_XSL("email-xslts/hotel.xsl"),
        EMAIL_FOR_OUTLOOKER_DEFAULT_XSL("email-xslts/event-outlooker-default.xsl"),
        EMAIL_FOR_OUTLOOKER_CANCEL_XSL("email-xslts/event-outlooker-cancel.xsl"),
        EMAIL_FOR_OUTLOOKER_REPLY_XSL("email-xslts/event-outlooker-reply.xsl"),
        ;

        private final String relPath; // concatenated at right side with ROOT_RES_DIR
        private ResourceName(String relPath) { this.relPath = relPath; }
        public StreamSource getSS() { return getResourceSS(relPath); }
        public InputStreamSource getIS() { return new SimpleInputStreamSource(getResourceIS(relPath)); }

        public ListF<Language> getSupportedLangs() {
            return this == ResourceName.EMAIL_TODO_LIST_XSL
                    ? Language.R.valuesList()
                    : Cf.list(Language.RUSSIAN, Language.ENGLISH);
        }
    } // enum ends

    // Common functionality methods

    public static InputStream getResourceIS(final String resName) {
        Validate.notEmpty(resName);
        InputStream resourceAsStream = CalendarClassPathResourceUtils.class.getResourceAsStream(ROOT_RES_DIR + resName);
        if (resourceAsStream == null)
            throw new RuntimeIoException("resource " + resName + " was not found");
        return resourceAsStream;
    }

    public static StreamSource getResourceSS(final String resName) {
        StreamSource r = new StreamSource(getResourceIS(resName));
        r.setPublicId("resource " + resName);
        return r;
    }

}
