package ru.yandex.calendar.util.resources;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.calendar.logic.user.NameI18n;

/**
 * Contains unicode string literals that we have to have within java code.
 * TODO create separate .properties file to contain these strings
 * @author ssytnik
 */
public class UStringLiteral {
    public static final String QUOTE_PATTERN_STR = "[" +
        "\u0027\u0060\u00ab\u00bb\u2018\u2019\u201b\u201c" +
        "\u201d\u201f\u2032\u2033\u2034\u2035\u2036\u2037\u2057" +
    "]";
    public static final String YANDEX = "Яндекс";
    public static final String YA_CALENDAR = "Яндекс.Календарь";
    public static final String YA_CALENDAR_EN = "Yandex.Calendar";

    public static final String MY_EVENTS = "Мои события";
    public static final String MY_EVENTS_EN = "My events";

    // UTF: "\u041c\u043e\u0438 \u0441\u043e\u0431\u044b\u0442\u0438\u044f"
    public static final String DEAR_USER = "Уважаемый пользователь";
    public static final String USER_NAME_UNKNOWN = "Имя неизвестно";
    public static final String YOUR_FRIEND = "Ваш друг";
    // UTF: "\u0423\u0432\u0430\u0436\u0430\u0435\u043c\u044b\u0439 " +
    //      "\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c"
    public static final String NO_NAME = "Без названия"; // Used for : ics default event name
    public static final String NO_CATEGORY = "(Без категории)"; // Used for : ics layer

    public static final String ROOM_PHONES = "Телефоны переговорок";
    public static final String VIDEO = "Видео";
    public static final String NO_PHONE = "Нет связи";

    public static final String TEL_LC = "тел.";
    public static final String FLOOR_LC = "этаж";
    public static final String VIDEO_LC = VIDEO.toLowerCase();
    public static final String NO_PHONE_LC = NO_PHONE.toLowerCase();

    public static final String MEETING_ROOM_RU = "Переговорка";
    public static final String MEETING_ROOM_EN = "Meeting room";

    // Cities
    public static final String YEKATERINBURG = "Екатеринбург";
    public static final String KAZAN = "Казань";
    public static final String KIEV = "Киев";
    public static final String MOSCOW = "Москва";
    public static final String NOVOSIBIRSK = "Новосибирск";
    public static final String SAINT_PETERSBURG = "Санкт-Петербург";
    public static final String SIMFEROPOL = "Симферополь";
    public static final String ODESSA = "Одесса";
    public static final String MINSK = "Минск";
    public static final String ISTANBUL = "Стамбул";
    public static final String ALMATY = "Алматы";
    public static final String TEL_AVIV = "Тель-Авив";
    public static final String PRAGUE = "Прага";

    public static final String CALIFORNIA = "Калифорния";
    public static final String ZURICH = "Цюрих";
    public static final String LUCERNE = "Люцерн";
    public static final String BERLIN = "Берлин";

    // Countries
    public static final String USA = "Сша";
    public static final String UKRAINE = "Украина";
    public static final String BELARUS = "Беларусь";
    public static final String TURKEY = "Турция";
    public static final String GERMANY = "Германия";

    public static final ListF<String> DAYS_OF_WEEK =
            Cf.list("понедельник", "вторник", "среда", "четверг", "пятница", "суббота", "воскресенье");
    public static final ListF<String> GENITIVE_MONTHS =
            Cf.list("января", "февраля", "марта", "апреля", "мая", "июня",
                    "июля", "августа", "сентября", "октября", "ноября", "декабря");

    public static final NameI18n TODAY = new NameI18n("Сегодня", "Today");
    public static final NameI18n TOMORROW = new NameI18n("Завтра", "Tomorrow");

    public static final NameI18n TEL_LCI = new NameI18n("тел.", "ph");
    public static final NameI18n VIDEO_LCI = new NameI18n("видео", "video");

} // class
