package ru.yandex.calendar.util.rr;

import java.util.UUID;

import lombok.val;
import net.fortuna.ical4j.model.Calendar;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.frontend.api.mail.MailDecision;
import ru.yandex.calendar.frontend.api.mail.MailEventBaseInfo;
import ru.yandex.calendar.frontend.api.mail.MailEventChangesInfo;
import ru.yandex.calendar.frontend.api.mail.MailParticipantInfo;
import ru.yandex.calendar.frontend.api.mail.MailParticipantsInfo;
import ru.yandex.calendar.frontend.api.mail.MailRepetitionInfo;
import ru.yandex.calendar.logic.beans.Bean;
import ru.yandex.calendar.logic.beans.IntegerArray;
import ru.yandex.calendar.logic.beans.NullableOtherValue;
import ru.yandex.calendar.logic.beans.generated.Event;
import ru.yandex.calendar.logic.beans.generated.EventNotification;
import ru.yandex.calendar.logic.beans.generated.TodoItem;
import ru.yandex.calendar.logic.beans.generated.UserGroups;
import ru.yandex.calendar.logic.contact.UnivContact;
import ru.yandex.calendar.logic.event.EventChangesInfoForMails;
import ru.yandex.calendar.logic.event.repetition.RepetitionHints;
import ru.yandex.calendar.logic.event.repetition.RepetitionInstanceInfo;
import ru.yandex.calendar.logic.ics.iv5j.ical.IcsCalendar;
import ru.yandex.calendar.logic.mailer.model.MailerParticipant;
import ru.yandex.calendar.logic.notification.Channel;
import ru.yandex.calendar.logic.sending.param.EventLocation;
import ru.yandex.calendar.logic.sending.param.EventMessageParameters;
import ru.yandex.calendar.logic.sending.param.MessageParameters;
import ru.yandex.calendar.logic.sending.param.Sender;
import ru.yandex.calendar.logic.sharing.EventParticipantsChangesInfo;
import ru.yandex.calendar.logic.user.Language;
import ru.yandex.calendar.logic.user.NameI18n;
import ru.yandex.calendar.logic.user.NameI18nWithOptionality;
import ru.yandex.calendar.logic.user.TestUsers;
import ru.yandex.commune.mapObject.MapField;
import ru.yandex.commune.random.RandomValueGenerator;
import ru.yandex.inside.passport.blackbox.PassportDomain;
import ru.yandex.mail.cerberus.yt.staff.dto.StaffUser.Gender;
import ru.yandex.misc.bender.annotation.BenderParseSubclasses;
import ru.yandex.misc.email.Email;
import ru.yandex.misc.random.Random2;
import ru.yandex.misc.reflection.ClassX;
import ru.yandex.misc.reflection.ConstructorX;
import ru.yandex.misc.time.InstantInterval;

public class CalendarRandomValueGenerator extends RandomValueGenerator {
    public static final CalendarRandomValueGenerator R = new CalendarRandomValueGenerator();

    @Override
    protected Object randomValueImpl(ClassX<Object> type) {
        if (type.sameAs(EventLocation.class)) {
            return EventLocation.location(randomValue(String.class));
        } else if (type.sameAs(Sender.class)) {
            return new Sender(Option.empty(), Option.empty(), new NameI18n("", ""), Option.empty(), new Email("a@b"));
        } else if (type.sameAs(UnivContact.class)) {
            return new UnivContact(new Email("drylev@yandex-team.ru"), "", Option.of(TestUsers.DBRYLEV));
        } else if (type.sameAs(RepetitionHints.class)) {
            return RepetitionHints.createDefaults(DateTime.now(DateTimeZone.UTC));
        } else if (type.sameAs(MailEventChangesInfo.class)
                || type.sameAs(MailEventBaseInfo.class)
                || type.sameAs(MailParticipantsInfo.class))
        {
            ConstructorX<?> constructor = type.getConstructors().first();
            return constructor.newInstanceL(constructor.getGenericParameterTypes().map(super::randomValue));
        } else if (type.sameAs(MailParticipantInfo.class)) {
            return new MailParticipantInfo.ExternalUser(
                    randomValue(String.class), randomValue(Email.class), MailDecision.ACCEPTED);
        } else if (type.sameAs(EventChangesInfoForMails.class)) {
            return new EventChangesInfoForMails(
                    super.randomValue(boolean.class),
                    super.randomValue(boolean.class),
                    super.randomValue(boolean.class),
                    super.randomValue(boolean.class),
                    EventParticipantsChangesInfo.EMPTY);
        } else if (type.sameAs(Gender.class)) {
            return Random2.R.nextBoolean() ? Gender.MALE : Gender.FEMALE;
        } else if (type.sameAs(Calendar.class)) {
            return new Calendar();
        } else if (type.sameAs(IcsCalendar.class)) {
            return new IcsCalendar();
        } else if (type.sameAs(Event.class)) {
            Event event = new Event();
            event.setId(randomLong());
            return event;
        } else if (type.sameAs(TodoItem.class)) {
            TodoItem todoItem = new TodoItem();
            //todoItem.setId(randomLong());
            //todoItem.setTodoListId(randomLong());
            todoItem.setTitle(r.nextString(10));
            todoItem.setCreationTs(randomInstant());
            if (r.nextBoolean()) {
                todoItem.setCompletionTs(randomInstant());
            } else {
                todoItem.setCompletionTsNull();
            }
            if (r.nextBoolean()) {
                todoItem.setDueTs(randomInstant());
            } else {
                todoItem.setDueTsNull();
            }
            return todoItem;
        } else if (type.sameAs(NameI18n.class)) {
            String v = r.nextString(7);
            return new NameI18n("ru-" + v, Option.of("en-" + v));
        } else if (type.sameAs(NameI18nWithOptionality.class)) {
            String v = r.nextString(7);
            boolean b = r.nextBoolean();
            return new NameI18nWithOptionality(new NameI18n("ru-" + v, Option.of("en-" + v)), b);
        } else if (type.sameAs(UserGroups.class)) {
            UserGroups userGroups = new UserGroups();
            userGroups.setUid(TestUsers.DBRYLEV);
            val arraySize = Math.abs(r.nextInt());
            userGroups.setGroups(new IntegerArray(r.nextInts(arraySize)));
            return userGroups;
        } else if (type.sameAs(EventNotification.class)) {
            EventNotification en = new EventNotification();
            en.setChannel(randomValue(Channel.class));
            en.setEventUserId(randomLong());
            en.setId(randomLong());
            en.setNextSendTs(randomInstant());
            en.setOffsetMinute(randomInt());
            return en;
        } else if (type.sameAs(PassportDomain.class)) {
            return PassportDomain.YANDEX_TEAM_RU;
        } else if (type.isAssignableTo(Bean.class)) {
            Bean instance = (Bean) type.newInstance();
            for (MapField field : instance.getHelper().beanMapObjectDescription().getFields()) {
                instance.setFieldValue(field, this.randomValue(field.getType()));
            }
            return instance;
        } else if (type.isAssignableTo(NullableOtherValue.class)) {
            return NullableOtherValue.none();
        } else if (type.isAssignableTo(UUID.class)) {
            return UUID.randomUUID();

        } else if (type.sameAs(EventMessageParameters.class)) {
            return randomValue(r.randomElement(EventMessageParameters.class
                    .getAnnotation(BenderParseSubclasses.class).value()));

        } else if (type.sameAs(MessageParameters.class)) {
            return randomValue(r.randomElement(MessageParameters.class
                    .getAnnotation(BenderParseSubclasses.class).value()));

        } else if (type.sameAs(MailerParticipant.class)) {
            return randomValue(r.randomElement(Cf.list(
                    MailerParticipant.User.class,
                    MailerParticipant.Resource.class,
                    MailerParticipant.External.class)));
        } else if (type.sameAs(MailRepetitionInfo.class)){
            return new MailRepetitionInfo(
                    new RepetitionInstanceInfo(randomValue(InstantInterval.class), randomValue(DateTimeZone.class),
                            Option.empty()),
                    randomValue(boolean.class),
                    randomValue(Language.class)
            );
        } else if (type.hasAnnotation(FillWithAllArgsConstructor.class)) {
            ConstructorX<?> constructor = type.getConstructors().single();

            return constructor.newInstanceL(constructor.getGenericParameterTypes()
                    .zip(getParameterWithSamples(constructor))
                    .map(randomValueWithSampleF()));

        } else {
            return super.randomValueImpl(type);
        }
    }

} //~
