package ru.yandex.calendar.util.spring;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author Sergey Shinderuk
 */
public class ChildApplicationContextLoader {

    private static final Logger logger = LoggerFactory.getLogger(ChildApplicationContextLoader.class);

    @Autowired
    protected ApplicationContext parentContext;

    protected final AnnotationConfigApplicationContext childContext;

    public ChildApplicationContextLoader(Class<?>... configurationClasses) {
        childContext = new AnnotationConfigApplicationContext();
        childContext.register(configurationClasses);
    }

    @PostConstruct
    public void initChildContext() {
        logger.info("Initializing child application context");
        childContext.setParent(parentContext);
        childContext.refresh();
    }

    @PreDestroy
    public void destroyChildContext() {
        logger.info("Destroying child application context");
        childContext.destroy();
    }

}
