package ru.yandex.calendar.util.spring;

import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;

import ru.yandex.calendar.logic.domain.PassportAuthDomains;
import ru.yandex.inside.passport.blackbox.PassportAuthDomain;
import ru.yandex.misc.property.PropertiesHolder;

/**
 * @author dbrylev
 */
public class YandexTeamCondition implements Condition {

    @Override
    public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
        return PassportAuthDomains.byProperty(PropertiesHolder.properties()).get()
                .containsTs(PassportAuthDomain.YANDEX_TEAM_RU);
    }
}
