package ru.yandex.calendar.util.ssl;

import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author akirakozov
 */
public class SslUtils {
    private static final Logger logger = LoggerFactory.getLogger(SslUtils.class);
    private static TrustManager trustManager;

    /**
     * @author akirakozov
     */
    private static class AllTrustingTrustManager implements X509TrustManager {
        public java.security.cert.X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        public void checkServerTrusted(X509Certificate[] certs, String authType)
                throws CertificateException {
        }

        public void checkClientTrusted(X509Certificate[] certs, String authType)
                throws CertificateException {
        }
    }

    private static class ClientAuthenticator extends Authenticator {
        private final String login;
        private final String password;

        public ClientAuthenticator(String login, String password) {
            this.login = login;
            this.password = password;
        }

        public PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(login, password.toCharArray());
        }
    }

    public static TrustManager getAllTrustingTrustManager() {
        if (trustManager == null) {
            trustManager = new AllTrustingTrustManager();
        }
        return trustManager;
    }

    public static Authenticator getAuthenticator(String login, String password) {
        return new ClientAuthenticator(login, password);
    }

    public static void initializeTrustConnection() {
        TrustManager[] trustAllCerts = new TrustManager[] { getAllTrustingTrustManager() };

        try {
            // 1. create all trusted trust manager to avoid certificate check
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new java.security.SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());

            // 2. Override host name verification, because we doesn't have real certificate
            HostnameVerifier hv = new HostnameVerifier() {
                public boolean verify(String urlHostName, SSLSession session) {
                    logger.warn(
                            "Warning: URL host '" + urlHostName +
                            "' is different to SSLSession host '" +
                            session.getPeerHost() + "'.");
                    return true;
                }
            };
            HttpsURLConnection.setDefaultHostnameVerifier(hv);
        } catch (KeyManagementException e) {
            e.printStackTrace();
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }
}
