package ru.yandex.calendar.util.wiki;

import java.net.URI;

import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;

import ru.yandex.calendar.util.json.JacksonUtils;
import ru.yandex.misc.io.http.apache.v4.ApacheHttpClientUtils;
import ru.yandex.misc.io.http.apache.v4.ReadStringResponseHandler;
import ru.yandex.misc.lang.Check;

public class WikiApiClient {

    private final String baseUrl;
    private final String oauth;
    private final HttpClient httpClient;

    public WikiApiClient(String baseUrl, String oauth, HttpClient httpClient) {
        this.baseUrl = baseUrl;
        this.oauth = oauth;
        this.httpClient = httpClient;
    }

    /**
     * Returns content of the wiki page formatted as HTML.
     *
     * @param wikiPage absolute path to wiki page, e.g. "/users/JohnDoe"
     */
    public String getFormatted(String wikiPage) {
        Check.isFalse(oauth.isEmpty(), "Wiki is unavailable due to missing auth token");

        HttpGet get = new HttpGet();
        get.addHeader("Authorization", "OAuth " + oauth);
        get.setURI(URI.create(baseUrl + wikiPage + "/.html"));

        return JacksonUtils.readTree(ApacheHttpClientUtils.execute(get, httpClient, new ReadStringResponseHandler()))
                .get("data").get("html").asText();
    }
}
