package ru.yandex.calendar.util.wiki;

import io.micrometer.core.instrument.MeterRegistry;
import org.apache.http.client.HttpClient;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.calendar.util.HttpClientConfiguration;

@Configuration
public class WikiApiClientContextConfiguration {

    @Value("${wiki.baseUrl}")
    private String baseUrl;

    @Value("${wiki.oauth:-}")
    private String oauth;

    @Bean
    public WikiApiClient wikiApiClient(MeterRegistry registry) {
        HttpClient httpClient = HttpClientConfiguration.fromProperties("wiki").consTrustAllClient(registry, "wiki");

        return new WikiApiClient(baseUrl, oauth, httpClient);
    }
}
