package ru.yandex.calendar.util.wiki;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import ru.yandex.bolts.function.Function;
import ru.yandex.misc.io.http.UrlUtils;
import ru.yandex.misc.regex.Pattern2;

/**
 * @author Eugene Voytitsky
 */
public class WikiUtils {

    private static final Pattern2 HEAD_RE =
            new Pattern2(Pattern.compile(
                    "(<h[1-7])[^>]*>"
                            + ".*?</a></div>([^<]+?)<span.*?"
                    + "(</h[1-7]>)"));

    private static final Pattern2 HIDE_REFERER_RE =
            new Pattern2(Pattern.compile("((?:href|src)=\")(?:https?:)?//h.yandex-team.ru/\\?([^\"]+\")"));

    public static String cleanHeads(String wikiPageInHtml) {
        String result = replaceAll(HEAD_RE, wikiPageInHtml, new Function<Matcher, String>() {
            public String apply(Matcher m) {
                return m.group(1) + '>' + m.group(2) + m.group(3);
            }
        });

        return result;
    }

    public static String stripHideRefererFromLinks(String wikiPageInHtml) {
        String result = replaceAll(HIDE_REFERER_RE, wikiPageInHtml, new Function<Matcher, String>() {
            public String apply(Matcher m) {
                return m.group(1) + UrlUtils.urlDecode(m.group(2));
            }
        });

        return result;
    }

    // TODO: move to Pattern2
    public static String replaceAll(Pattern2 p, String string, final Function<Matcher, String> replacement) {
        StringBuffer result = new StringBuffer();
        Matcher matcher = p.matcher(string);
        while (matcher.find()) {
            matcher.appendReplacement(result, replacement.apply(matcher));
        }
        matcher.appendTail(result);
        return result.toString();
    }

}
