package ru.yandex.calendar.util.xmlorjson;

/**
 * @author gutman
 * @author Sergey Shinderuk
 */
public abstract class XmlOrJsonWriter {

    public abstract void startObject(String name);
    public abstract void endObject();

    public abstract void startArray(String name);
    public abstract void endArray();

    public abstract void addTextField(String name, String value);

    public void addTextField(String name, long value) {
        addTextField(name, Long.toString(value));
    }

    public abstract void addNumberField(String name, int value);

    public abstract void addNumberField(String name, long value);

    public abstract void addNumberField(String name, float value);

    public abstract void addNumberField(String name, double value);

    public abstract void addBooleanField(String name, boolean value);

    public abstract void addNullField(String name);

    public abstract boolean isXml();

    public abstract ru.yandex.misc.xml.stream.XmlWriter getXmlWriter();

    public abstract ru.yandex.commune.json.write.JsonWriter getJsonWriter();

}
