package ru.yandex.calendar.util.xmlorjson;

import ru.yandex.calendar.util.base.Binary;
import ru.yandex.commune.json.write.JsonWriter;

/**
 * @author gutman
 * @author Sergey Shinderuk
 */
public class XmlWriter extends XmlOrJsonWriter {

    private final ru.yandex.misc.xml.stream.XmlWriter xw;

    public XmlWriter(ru.yandex.misc.xml.stream.XmlWriter xw) {
        this.xw = xw;
    }

    @Override
    public void startObject(String name) {
        xw.startElement(name);
    }

    @Override
    public void endObject() {
        xw.endElement();
    }

    @Override
    public void startArray(String name) {
        xw.startElement(name);
    }

    @Override
    public void endArray() {
        xw.endElement();
    }

    @Override
    public void addTextField(String name, String value) {
        xw.textElement(name, value);
    }

    @Override
    public void addNumberField(String name, int value) {
        xw.textElement(name, Integer.toString(value));
    }

    @Override
    public void addNumberField(String name, long value) {
        xw.textElement(name, Long.toString(value));
    }

    @Override
    public void addNumberField(String name, float value) {
        xw.textElement(name, Float.toString(value));
    }

    @Override
    public void addNumberField(String name, double value) {
        xw.textElement(name, Double.toString(value));
    }

    @Override
    public void addBooleanField(String name, boolean value) {
        xw.textElement(name, Binary.toString(value));
    }

    @Override
    public void addNullField(String name) {
        xw.emptyElement(name);
    }

    @Override
    public boolean isXml() {
        return true;
    }

    @Override
    public ru.yandex.misc.xml.stream.XmlWriter getXmlWriter() {
        return xw;
    }

    @Override
    public JsonWriter getJsonWriter() {
        throw new UnsupportedOperationException();
    }
}
