package ru.yandex.calendar.zk;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.commune.zk2.ZkConfiguration;
import ru.yandex.commune.zk2.ZkPath;
import ru.yandex.commune.zk2.client.ZkManagerContextConfiguration;
import ru.yandex.inside.admin.conductor.Conductor;
import ru.yandex.misc.lang.StringUtils;

/**
 * @author Stepan Koltsov
 */
@Import(ZkManagerContextConfiguration.class)
@Configuration
public class CalendarZkContextConfiguration {

    @Bean
    public EnvironmentId environmentId() {
        return new EnvironmentId();
    }

    @Qualifier("zkRoot")
    @Bean
    public ZkPath zkRoot() {
        return new ZkPath("/calendar/" + environmentId().environmentId());
    }

    @Bean
    public ZkPath calendarZkPath() {
        return zkRoot().child("calendar");
    }

    @Autowired
    private Conductor conductor;

    @Bean
    public ZkConfiguration zkConfiguration(
            @Value("${zookeeper.hosts:-}") String zkHosts,
            @Value("${zookeeper.conductor.group:-}") String zkConductorGroup,
            @Value("${zookeeper.port}") int zkPort)
    {
        if (StringUtils.isNotEmpty(zkConductorGroup)) {
            return new ZkConfiguration(conductor.getGroupHosts(zkConductorGroup), zkPort);
        }
        return new ZkConfiguration(Cf.x(zkHosts.split(",")).filter(StringUtils::isNotEmpty), zkPort);
    }

} //~
