package ru.yandex.calendar.zk;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.calendar.logic.domain.PassportAuthDomainsHolder;
import ru.yandex.misc.env.EnvironmentType;
import ru.yandex.misc.net.HostnameUtils;

/**
 * @author Stepan Koltsov
 */
public class EnvironmentId {

    @Autowired
    private PassportAuthDomainsHolder passportAuthDomainsHolder;
    @Autowired
    private EnvironmentType environmentType;

    public String environmentId() {
        if (environmentType == EnvironmentType.DEVELOPMENT) {
            return HostnameUtils.localHostname();
        } else {
            EnvironmentType type = EnvironmentType.getActive();

            if (type == EnvironmentType.PRESTABLE) {
                type = EnvironmentType.PRODUCTION;
            }
            return type.name().toLowerCase()
                    + "-" + passportAuthDomainsHolder.asString()
                    + EnvironmentType.getActiveSecondary().map("-"::concat).orElse("");
        }
    }

} //~
