<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

    <xsl:import href="email-xslts/apartment-common.xsl"/>

    <xsl:variable name="subject" select="'Бронирование квартиры отменено'"/>

    <xsl:template match="message">
        <message>
            <xsl:call-template name="message-header">
                <xsl:with-param name="subject" select="$subject"/>
            </xsl:call-template>

            <part id="1" type="single" content-type="text/html; charset=utf-8">
                <xsl:call-template name="text-part-html-common"/>
            </part>
        </message>
    </xsl:template>

    <xsl:template name="text-part-html-custom">
        <table cellpadding="4" width="100%">
            <xsl:call-template name="subject">
                <xsl:with-param name="color" select="'#f6e9e4'"/>
                <xsl:with-param name="subject" select="$subject"/>
            </xsl:call-template>
            <xsl:call-template name="when"/>
            <xsl:call-template name="where"/>
            <xsl:call-template name="description"/>
        </table>
    </xsl:template>

    <xsl:template name="footer-html"/>
    <xsl:template name="text-part-plain-custom"/>

</xsl:stylesheet>
