<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="urn:yandex-functions:internationalization"
                exclude-result-prefixes="i18n">

    <xsl:import href="email-xslts/common-event.xsl" />
    <xsl:output method="html" indent="no"/>

    <xsl:template name="subject">
        <xsl:param name="subject"/>
        <xsl:param name="color"/>
        <tr bgcolor="{$color}">
            <td style="padding: 7px 15px 7px" colspan="3">
                <font face="Arial,sans-serif" size="4">
                    <b>
                        <xsl:value-of select="$subject"/>
                    </b>
                </font>
            </td>
        </tr>
    </xsl:template>

    <xsl:template name="when">
        <xsl:call-template name="row">
            <xsl:with-param name="name">
                <xsl:call-template name="i18n:calendar.emails2.When"/>
            </xsl:with-param>

            <xsl:with-param name="value">
                <xsl:call-template name="date-time-interval-with-tz"/>
            </xsl:with-param>
        </xsl:call-template>
    </xsl:template>

    <xsl:template name="where_value">
        <xsl:if test="/message/event-location/resources">
            <xsl:apply-templates select="/message/event-location/resources" mode="plain"/>
        </xsl:if>
        <xsl:if test="/message/event-location/location-text">
            <xsl:apply-templates select="/message/event-location/location-text" mode="plain"/>
        </xsl:if>
    </xsl:template>

    <xsl:template name="where">
        <xsl:call-template name="row">
            <xsl:with-param name="name">
                <xsl:call-template name="i18n:calendar.emails2.Where"/>
            </xsl:with-param>
            <xsl:with-param name="value">
                <xsl:call-template name="where_value"/>
            </xsl:with-param>
        </xsl:call-template>
    </xsl:template>

    <xsl:template name="organizer">
        <xsl:call-template name="row">
            <xsl:with-param name="name" select="'Кто бронировал'"/>
            <xsl:with-param name="value" select="/message/organizer/text()"/>
        </xsl:call-template>
    </xsl:template>

    <xsl:template name="customers_value">
        <xsl:for-each select="/message/customers/customer">
            <xsl:value-of select="."/>
            <xsl:if test="position() != last()"><xsl:text>, </xsl:text></xsl:if>
        </xsl:for-each>
    </xsl:template>

    <xsl:template name="customers">
        <xsl:call-template name="row">
            <xsl:with-param name="name" select="'Кто проживает'"/>
            <xsl:with-param name="value">
                <xsl:call-template name="customers_value"/>
            </xsl:with-param>
        </xsl:call-template>
    </xsl:template>

    <xsl:template name="description">
        <xsl:call-template name="row">
            <xsl:with-param name="name" select="'Комментарий'"/>
            <xsl:with-param name="value">
                <xsl:apply-templates select="/message/event-description-xml"/>
            </xsl:with-param>
        </xsl:call-template>
    </xsl:template>

    <xsl:template name="rules">
        <xsl:if test="/message/rules">
            <xsl:call-template name="row">
                <xsl:with-param name="disable_escape" select="true()"/>
                <xsl:with-param name="name" select="'Правила проживания'"/>
                <xsl:with-param name="value" select="/message/rules/text()"/>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>

    <xsl:template match="/message/event-description-xml">
        <xsl:apply-templates mode="html"/>
    </xsl:template>

    <xsl:template name="row">
        <xsl:param name="disable_escape" select="false()"/>
        <xsl:param name="name"/>
        <xsl:param name="value"/>

        <xsl:if test="$value != ''">
            <tr>
                <td valign="top" width="150">
                    <font color="#a2a2a2" face="Arial,sans-serif" size="3">
                        <b>
                            <xsl:copy-of select="$name"/>
                        </b>
                    </font>
                </td>
                <td width="5"/>
                <td>
                    <font face="Arial,sans-serif" size="3">
                        <xsl:if test="$disable_escape">
                            <xsl:value-of select="$value" disable-output-escaping="yes"/>
                        </xsl:if>
                        <xsl:if test="not($disable_escape)">
                            <xsl:copy-of select="$value"/>
                        </xsl:if>
                    </font>
                </td>
            </tr>
        </xsl:if>
    </xsl:template>

</xsl:stylesheet>
