<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        exclude-result-prefixes="xsl"
        version="1.0">

    <xsl:import href="email-xslts/common-message.xsl" />
    <xsl:output method="html" indent="no"/>

    <xsl:template match="message">
        <message type="alternative">
            <xsl:call-template name="message-header">
                <xsl:with-param name="subject">
                    <xsl:text>Сломался планшет переговорки </xsl:text>
                    <xsl:value-of select="resource/name-with-alter"/>
                </xsl:with-param>
            </xsl:call-template>

            <part id="1" content-type="text/html; charset=utf-8">
                <html>
                    <head>
                        <meta http-equiv="Content-type" content="text/html; charset=utf-8" />
                    </head>
                    <body>
                        <p>
                            Планшет, привязанный к переговорке <xsl:value-of select="resource/name"/>,
                            <xsl:if test="not(resource/map-url)"><xsl:value-of select="resource/location"/></xsl:if>
                            <xsl:if test="resource/map-url"><a href="{resource/map-url}"><xsl:value-of select="resource/location"/></a></xsl:if>,
                            перестал подавать признаки жизни.
                        </p>
                    </body>
                </html>
            </part>
        </message>
    </xsl:template>
</xsl:stylesheet>
