<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

    <xsl:import href="email-xslts/apartment-common.xsl"/>

    <xsl:template match="mail-type[. = 'campus-invitation']" mode="subject">
        <xsl:text>Подтверждение бронирования кампуса</xsl:text>
    </xsl:template>
    <xsl:template match="mail-type[. = 'campus-update']" mode="subject">
        <xsl:text>Изменена информация о бронировании кампуса</xsl:text>
    </xsl:template>
    <xsl:template match="mail-type[. = 'campus-cancel']" mode="subject">
        <xsl:text>Бронирование кампуса отменено</xsl:text>
    </xsl:template>

    <xsl:template match="mail-type[. = 'campus-invitation']" mode="color">
        <xsl:text>#e4f0df</xsl:text>
    </xsl:template>
    <xsl:template match="mail-type[. = 'campus-update']" mode="color">
        <xsl:text>#e3eafd</xsl:text>
    </xsl:template>
    <xsl:template match="mail-type[. = 'campus-cancel']" mode="color">
        <xsl:text>#f6e9e4</xsl:text>
    </xsl:template>

    <xsl:template match="message">
        <message>
            <xsl:call-template name="message-header">
                <xsl:with-param name="subject">
                    <xsl:apply-templates select="mail-type" mode="subject"/>
                </xsl:with-param>
            </xsl:call-template>

            <part id="1" type="single" content-type="text/html; charset=utf-8">
                <xsl:call-template name="text-part-html-common"/>
            </part>
        </message>
    </xsl:template>

    <xsl:template name="text-part-html-custom">
        <table cellpadding="4" width="100%">
            <xsl:call-template name="subject">
                <xsl:with-param name="color">
                    <xsl:apply-templates select="/message/mail-type" mode="color"/>
                </xsl:with-param>
                <xsl:with-param name="subject">
                    <xsl:apply-templates select="/message/mail-type" mode="subject"/>
                </xsl:with-param>
            </xsl:call-template>
            <xsl:call-template name="when"/>
            <xsl:call-template name="where"/>
            <xsl:call-template name="customers"/>
            <xsl:call-template name="organizer"/>
            <xsl:call-template name="description"/>
        </table>
    </xsl:template>

    <xsl:template name="footer-html"/>
    <xsl:template name="text-part-plain-custom"/>

</xsl:stylesheet>
