<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet [
        <!ENTITY quot   "&#34;">
        <!ENTITY laquo  "&#171;">
        <!ENTITY raquo  "&#187;">
        <!ENTITY nbsp   "&#160;">
        <!ENTITY copy   "&#169;">
        <!ENTITY rarr   "&#8594;">
        <!ENTITY larr   "&#8592;">
        <!ENTITY hellip "&#8230;">
        <!ENTITY mdash  "&#8212;">
        <!ENTITY copy   "&#169;">
        <!ENTITY lf     "&#x0A;">
        <!ENTITY ndash   "&#x2014;">
        ]>

<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:date="http://exslt.org/dates-and-times"
                xmlns:exsl="http://exslt.org/common"
                xmlns:dp="http://www.dpawson.co.uk"
                xmlns:xdt="http://www.w3.org/2005/02/xpath-datatypes"
                xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsh="http://www.w3.org/1999/XSL/Transform"
                extension-element-prefixes="xs dp exsl date xdt i18n"
                xmlns:i18n="urn:yandex-functions:internationalization">

    <xsl:import href="email-xslts/common-message.xsl"/>

    <xsl:import href="i18n/@LANGUAGE@/tanker.days.xsl"/>
    <xsl:import href="i18n/@LANGUAGE@/tanker.dynamic.xsl"/>
    <xsl:import href="i18n/@LANGUAGE@/tanker.months.xsl"/>
    <xsl:import href="i18n/@LANGUAGE@/calendar.emails2.xsl"/>

    <!-- Event, layer -->

    <xsl:variable name="event-id" select="message/event-id"/>
    <xsl:variable name="is-meeting" select="message/is-meeting = 1"/>
    <xsl:variable name="uid" select="message/uid"/>

    <xsl:variable name="query-uid-param">
        <xsl:if test="$uid"><xsl:text>?uid=</xsl:text><xsl:value-of select="$uid"/><xsl:text><![CDATA[&]]></xsl:text></xsl:if>
        <xsl:if test="not($uid)"><xsl:text>?</xsl:text></xsl:if>
    </xsl:variable>

    <xsl:variable name="query-uid-single-param">
        <xsl:if test="$uid"><xsl:text>?uid=</xsl:text><xsl:value-of select="$uid"/></xsl:if>
    </xsl:variable>

    <xsl:variable name="event-name">
        <xsl:value-of select="message/event-name"/>
    </xsl:variable>

    <xsl:variable name="q-event-name">
        <xsl:text>&laquo;</xsl:text>
        <xsl:value-of select="$event-name"/>
        <xsl:text>&raquo;</xsl:text>
    </xsl:variable>

    <xsl:variable name="ptk" select="message/private-token"/>

    <!-- Timing -->

    <!-- TODO support 'sup' (english): it looks good, but not for plain text -->
    <!-- XXX ssytnik@: tanker should do number suffixes -->
    <xsl:template name="number-with-suffix">
        <xsl:param name="number"/>
        <xsl:param name="gender"/> <!-- always singular: m (masculine), f (feminine), n (neuter) -->
        <xsl:param name="case"/> <!-- n (nominative), g (genitive), a (accusative) -->
        <!-- also uses $language -->

        <xsl:value-of select="$number"/>
        <xsl:choose>
            <xsl:when test="$language = 'en' or $language = 'tr'">
                <xsl:choose>
                    <xsl:when test="$number mod 10 = 1 and $number mod 100 != 11">st</xsl:when>
                    <xsl:when test="$number mod 10 = 2 and $number mod 100 != 12">nd</xsl:when>
                    <xsl:when test="$number mod 10 = 3 and $number mod 100 != 13">rd</xsl:when>
                    <xsl:otherwise>th</xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:when test="$language = 'ru'">
                <xsl:text>-</xsl:text>
                <xsl:choose>
                    <xsl:when test="$gender = 'm' and $case = 'n'">й</xsl:when>
                    <xsl:when test="$gender = 'm' and $case = 'g'">го</xsl:when>
                    <xsl:when test="$gender = 'm' and $case = 'a'">й</xsl:when>

                    <xsl:when test="$gender = 'f' and $case = 'n'">я</xsl:when>
                    <xsl:when test="$gender = 'f' and $case = 'g'">й</xsl:when>
                    <xsl:when test="$gender = 'f' and $case = 'a'">ю</xsl:when>

                    <xsl:when test="$gender = 'n' and $case = 'n'">е</xsl:when>
                    <xsl:when test="$gender = 'n' and $case = 'g'">го</xsl:when>
                    <xsl:when test="$gender = 'n' and $case = 'a'">е</xsl:when>
                </xsl:choose>
            </xsl:when>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="Date">
        <xsl:param name="day-number"/>
        <xsl:param name="month-number"/>
        <xsl:param name="case" select="'g'"/>

        <xsl:call-template name="i18n:calendar.emails2.Date">
            <xsl:with-param name="day">
                <xsl:call-template name="number-with-suffix">
                    <xsl:with-param name="number" select="$day-number"/>
                    <xsl:with-param name="gender" select="'n'"/>
                    <xsl:with-param name="case" select="$case"/>
                </xsl:call-template>
            </xsl:with-param>

            <xsl:with-param name="month-genitive">
                <xsl:call-template name="Month">
                    <xsl:with-param name="month-number" select="$month-number"/>
                </xsl:call-template>
            </xsl:with-param>
        </xsl:call-template>
    </xsl:template>

    <xsl:template name="Month">
        <xsl:param name="month-number"/>

        <xsl:call-template name="i18n:tanker.months.name">
            <xsl:with-param name="month" select="$month-number"/>
            <xsl:with-param name="case" select="'g'"/>
            <xsl:with-param name="lowercase" select="$language = 'ru'"/> <!-- XXX ssytnik: tanker should provide default value here -->
        </xsl:call-template>
    </xsl:template>

    <xsl:variable name="start-ts"><xsl:value-of select="message/event-start-ts"/></xsl:variable>
    <xsl:variable name="start-date" select="format-dateTime($start-ts, '[Y0001]-[M01]-[D01]', 'en', 'AD', '')"/>

    <xsl:variable name="end-ts"><xsl:value-of select="message/event-end-ts"/></xsl:variable>
    <xsl:variable name="end-date" select="format-dateTime($end-ts, '[Y0001]-[M01]-[D01]', 'en', 'AD', '')"/>

    <xsl:template name="when-full">
        <xsl:param name="upper" select="1"/>

        <xsl:variable name="days-diff"
            select="days-from-duration(
                xs:dateTime(format-dateTime($start-ts, '[Y0001]-[M01]-[D01]T00:00:00', 'en', 'AD', ''))
                - xs:dateTime(format-dateTime(date-time-now, '[Y0001]-[M01]-[D01]T00:00:00', 'en', 'AD', ''))
            )"
        />

        <xsl:variable name="hr-day">
            <xsl:choose>
                <xsl:when test="$days-diff = '0'"><xsl:call-template name="i18n:calendar.emails2.Today"/></xsl:when>
                <xsl:when test="$days-diff = '1'"><xsl:call-template name="i18n:calendar.emails2.Tomorrow"/></xsl:when>
                <xsl:otherwise>
                    <xsl:call-template name="i18n:tanker.days.acc">
                        <xsl:with-param name="day" select="format-dateTime($start-ts, '[F1]', 'en', 'AD', '')"/>
                    </xsl:call-template>
                </xsl:otherwise>
            </xsl:choose>
            <xsl:text>, </xsl:text>
        </xsl:variable>

        <xsl:if test="$upper = 1"><xsl:call-template name="capitalize"><xsl:with-param name="str" select="$hr-day"/></xsl:call-template></xsl:if>
        <xsl:if test="$upper != 1"><xsl:call-template name="uncapitalize"><xsl:with-param name="str" select="$hr-day"/></xsl:call-template></xsl:if>

        <xsl:call-template name="date-time-interval-with-tz"/>
    </xsl:template>

    <xsl:template name="when-full-lower">
        <xsl:call-template name="when-full"><xsl:with-param name="upper">0</xsl:with-param></xsl:call-template>
    </xsl:template>

    <xsl:template name="date-time-interval-with-tz">
        <xsl:call-template name="Date">
            <xsl:with-param name="day-number" select="format-dateTime($start-ts, '[D01]', 'en', 'AD', '')"/>
            <xsl:with-param name="month-number" select="format-dateTime($start-ts, '[M1]', 'en', 'AD', '')"/>
        </xsl:call-template>
        <xsl:variable name="x">
            <xsl:call-template name="no-start-date-date-time-interval-with-tz"/>
        </xsl:variable>
        <xsl:if test="$x != ''">
            <xsl:if test="$language = 'ru'">
                <xsl:text>, </xsl:text>
            </xsl:if>
            <xsl:if test="$language != 'ru'">
                <xsl:text> </xsl:text>
            </xsl:if>
            <xsl:value-of select="$x"/>
        </xsl:if>
    </xsl:template>

    <xsl:template name="no-start-date-date-time-interval-with-tz">
        <xsl:variable name="start-time"><xsl:value-of select="format-dateTime($start-ts, '[H01]:[m01]', 'en', 'AD', '')"/></xsl:variable>
        <xsl:variable name="end-time"><xsl:value-of select="format-dateTime($end-ts, '[H01]:[m01]', 'en', 'AD', '')"/></xsl:variable>

        <xsl:variable name="day-before-end-ts" select="xs:dateTime($end-ts) - xs:dayTimeDuration('P1D')"/>
        <xsl:variable name="day-before-end-date" select="format-dateTime($day-before-end-ts, '[Y0001]-[M01]-[D01]', 'en', 'AD', '')"/>

        <xsl:variable name="end-date-formatted">
            <xsl:call-template name="Date">
                <xsl:with-param name="day-number" select="format-dateTime($end-ts, '[D01]', 'en', 'AD', '')"/>
                <xsl:with-param name="month-number" select="format-dateTime($end-ts, '[M1]', 'en', 'AD', '')"/>
            </xsl:call-template>
        </xsl:variable>
        <xsl:variable name="day-before-end-date-formatted">
            <xsl:call-template name="Date">
                <xsl:with-param name="day-number" select="format-dateTime($day-before-end-ts, '[D01]', 'en', 'AD', '')"/>
                <xsl:with-param name="month-number" select="format-dateTime($day-before-end-ts, '[M1]', 'en', 'AD', '')"/>
                <xsl:with-param name="case" select="'a'"/>
            </xsl:call-template>
        </xsl:variable>

        <xsl:variable name="true-all-day" select="show-is-all-day = 1 and starts-with($start-time, '00:00') and starts-with($end-time, '00:00')"/>

        <xsl:if test="$true-all-day and $start-date != $day-before-end-date">
            <xsl:if test="$language = 'ru'">
                <xsl:text>по </xsl:text>
            </xsl:if>
            <xsl:if test="$language != 'ru'">
                <xsl:text>&ndash; </xsl:text>
            </xsl:if>
            <xsl:value-of select="$day-before-end-date-formatted"/>
        </xsl:if>
        <xsl:if test="not($true-all-day)">
            <xsl:call-template name="i18n:calendar.emails2.since-till">
                <xsl:with-param name="since">
                    <xsl:value-of select="$start-time"/>
                </xsl:with-param>
                <xsl:with-param name="till">
                    <xsl:value-of select="$end-time"/>
                    <xsl:if test="$start-date != $end-date">
                        <xsl:text> </xsl:text>
                        <xsl:value-of select="$end-date-formatted"/>
                    </xsl:if>
                </xsl:with-param>
            </xsl:call-template>
            <xsl:value-of select="secondary-tz-suffix"/>
        </xsl:if>
    </xsl:template>

    <xsl:template name="date-time-interval-simple">
        <xsl:call-template name="i18n:calendar.emails2.since-till">
            <xsl:with-param name="since">
                <xsl:value-of select="format-dateTime($start-ts, '[D01].[M01].[Y0001]', 'en', 'AD', '')"/>
            </xsl:with-param>
            <xsl:with-param name="till">
                <xsl:value-of select="format-dateTime($end-ts, '[D01].[M01].[Y0001]', 'en', 'AD', '')"/>
            </xsl:with-param>
        </xsl:call-template>
    </xsl:template>

    <xsl:template name="since-with-repetition">
        <xsl:call-template name="_since-with-repetition">
            <xsl:with-param name="no-due" select="false()"/>
        </xsl:call-template>
    </xsl:template>

    <xsl:template name="since-with-no-end-repetition">
        <xsl:call-template name="_since-with-repetition">
            <xsl:with-param name="no-due" select="true()"/>
        </xsl:call-template>
    </xsl:template>

    <xsl:template name="_since-with-repetition">
        <xsl:param name="no-due"/>

        <xsl:if test="rep-hints">
            <xsl:call-template name="rep-since"/>
            <xsl:text> </xsl:text>
            <xsl:call-template name="no-start-date-date-time-interval-with-tz"/>
            <xsl:text> </xsl:text>
            <xsl:apply-templates select="rep-hints/each"/>
            <xsl:text> </xsl:text>
            <xsl:apply-templates select="rep-hints/type"/>
            <xsl:if test="not($no-due)">
                <xsl:apply-templates select="rep-hints/due"/>
            </xsl:if>
        </xsl:if>

        <xsl:if test="not(rep-hints)">
            <xsl:call-template name = "when-full-lower"/>
        </xsl:if>
    </xsl:template>

    <!-- Repetitions -->

    <xsl:template name="rep-hints-text">
        <xsl:text>, </xsl:text>
        <xsl:call-template name="i18n:calendar.emails2.rep-repeats"/>
        <xsl:text> </xsl:text>
        <xsl:apply-templates select="each"/>
        <xsl:text> </xsl:text>
        <xsl:apply-templates select="type"/>
        <xsl:apply-templates select="due"/>
    </xsl:template>

    <xsl:template match="rep-hints/each[. = 1 and ../type = 'daily']"><xsl:call-template name="i18n:calendar.emails2.rep-daily"/></xsl:template>
    <xsl:template match="rep-hints/each[. = 1 and ../type = 'weekly']"><xsl:call-template name="i18n:calendar.emails2.rep-weekly"/></xsl:template>
    <xsl:template match="rep-hints/each[. = 1 and (../type = 'monthly_number' or ../type = 'monthly_day_weekno')]">
        <xsl:call-template name="i18n:calendar.emails2.rep-monthly"/>
    </xsl:template>
    <xsl:template match="rep-hints/each[. = 1 and ../type = 'yearly']"><xsl:call-template name="i18n:calendar.emails2.rep-yearly"/></xsl:template>

    <xsl:template match="rep-hints/each[. > 1 and ../type = 'daily']">
        <xsl:call-template name="i18n:calendar.emails2.rep-each-nth-day">
            <xsl:with-param name="n">
                <xsl:call-template name="number-with-suffix">
                    <xsl:with-param name="number" select="."/>
                    <xsl:with-param name="gender" select="'m'"/>
                    <xsl:with-param name="case" select="'a'"/>
                </xsl:call-template>
            </xsl:with-param>
        </xsl:call-template>
    </xsl:template>
    <xsl:template match="rep-hints/each[. > 1 and ../type = 'weekly']">
        <xsl:call-template name="i18n:calendar.emails2.rep-each-nth-week">
            <xsl:with-param name="n">
                <xsl:call-template name="number-with-suffix">
                    <xsl:with-param name="number" select="."/>
                    <xsl:with-param name="gender" select="'f'"/>
                    <xsl:with-param name="case" select="'a'"/>
                </xsl:call-template>
            </xsl:with-param>
        </xsl:call-template>
    </xsl:template>
    <xsl:template match="rep-hints/each[. > 1 and (../type = 'monthly_number' or ../type = 'monthly_day_weekno')]">
        <xsl:call-template name="i18n:calendar.emails2.rep-each-nth-month">
            <xsl:with-param name="n">
                <xsl:call-template name="number-with-suffix">
                    <xsl:with-param name="number" select="."/>
                    <xsl:with-param name="gender" select="'m'"/>
                    <xsl:with-param name="case" select="'a'"/>
                </xsl:call-template>
            </xsl:with-param>
        </xsl:call-template>
    </xsl:template>
    <xsl:template match="rep-hints/each[. > 1 and ../type = 'yearly']">
        <xsl:call-template name="i18n:calendar.emails2.rep-each-nth-year">
            <xsl:with-param name="n">
                <xsl:call-template name="number-with-suffix">
                    <xsl:with-param name="number" select="."/>
                    <xsl:with-param name="gender" select="'m'"/>
                    <xsl:with-param name="case" select="'a'"/>
                </xsl:call-template>
            </xsl:with-param>
        </xsl:call-template>
    </xsl:template>

    <xsl:template match="rep-hints/type[. = 'daily']"/>

    <xsl:template match="rep-hints/type[. = 'weekly']">
        <xsl:text>(</xsl:text>
        <xsl:apply-templates select="../weekdays"/>
        <xsl:text>)</xsl:text>
    </xsl:template>

    <xsl:template match="rep-hints/type[. = 'monthly_number']">
        <xsl:call-template name="i18n:calendar.emails2.rep-monthly-number-g">
            <xsl:with-param name="day">
                <xsl:call-template name="number-with-suffix">
                    <xsl:with-param name="number" select="../day"/>
                    <xsl:with-param name="gender" select="'n'"/>
                    <xsl:with-param name="case" select="'g'"/>
                </xsl:call-template>
            </xsl:with-param>
        </xsl:call-template>
    </xsl:template>

    <xsl:template match="rep-hints/type[. = 'monthly_day_weekno']">
        <xsl:variable name="weekday" select="../weekdays/weekday"/>
        <!-- XXX ssytnik@: tanker should provide gender for weekday -->
        <xsl:variable name="gender">
            <xsl:choose>
                <xsl:when test="$weekday = 1 or $weekday = 2 or $weekday = 4">m</xsl:when>
                <xsl:when test="$weekday = 3 or $weekday = 5 or $weekday = 6">f</xsl:when>
                <xsl:otherwise>n</xsl:otherwise>
            </xsl:choose>
        </xsl:variable>

        <xsl:text>(</xsl:text>
        <xsl:choose>
            <xsl:when test="../week-no = -1">
                <xsl:choose>
                    <xsl:when test="$gender = 'm'"><xsl:call-template name="i18n:calendar.emails2.rep-monthly-day-weekno-last-m"/></xsl:when>
                    <xsl:when test="$gender = 'f'"><xsl:call-template name="i18n:calendar.emails2.rep-monthly-day-weekno-last-f"/></xsl:when>
                    <xsl:when test="$gender = 'n'"><xsl:call-template name="i18n:calendar.emails2.rep-monthly-day-weekno-last-n"/></xsl:when>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="number-with-suffix">
                    <xsl:with-param name="number" select="../week-no"/>
                    <xsl:with-param name="gender" select="$gender"/>
                    <xsl:with-param name="case" select="'n'"/>
                </xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
        <xsl:text> </xsl:text>
        <xsl:apply-templates select="../weekdays"/>
        <xsl:text>)</xsl:text>
    </xsl:template>

    <xsl:template match="rep-hints/type[. = 'yearly']">
        <xsl:call-template name="Date">
            <xsl:with-param name="day-number" select="../day"/>
            <xsl:with-param name="month-number" select="../month"/>
        </xsl:call-template>
    </xsl:template>

    <xsl:template match="rep-hints/weekdays/weekday">
        <xsl:if test="position() &gt; 1"><xsl:text>, </xsl:text></xsl:if>
        <xsl:call-template name="i18n:tanker.days.name">
            <xsl:with-param name="day" select="."/>
        </xsl:call-template>
    </xsl:template>

    <xsl:template match="rep-hints/due">
        <xsl:variable name="day-number" select="format-date(., '[D1]', 'en', 'AD', '')"/>

        <xsl:text> </xsl:text>
        <xsl:call-template name="i18n:calendar.emails2.rep-due">
            <xsl:with-param name="day">
                <xsl:call-template name="number-with-suffix">
                    <xsl:with-param name="number" select="$day-number"/>
                    <xsl:with-param name="gender" select="'n'"/>
                    <xsl:with-param name="case" select="'g'"/>
                </xsl:call-template>
            </xsl:with-param>

            <xsl:with-param name="month-genitive">
                <xsl:call-template name="Month">
                    <xsl:with-param name="month-number" select="format-date(., '[M1]', 'en', 'AD', '')"/>
                </xsl:call-template>
            </xsl:with-param>

            <xsl:with-param name="year" select="format-date(., '[Y1]', 'en', 'AD', '')"/>
        </xsl:call-template>
    </xsl:template>

    <xsl:template name="rep-since">
        <xsl:call-template name="i18n:calendar.emails2.rep-since">
            <xsl:with-param name="day">
                <xsl:call-template name="number-with-suffix">
                    <xsl:with-param name="number" select="format-dateTime($start-ts, '[D01]', 'en', 'AD', '')"/>
                    <xsl:with-param name="gender" select="'n'"/>
                    <xsl:with-param name="case" select="'g'"/>
                </xsl:call-template>
            </xsl:with-param>

            <xsl:with-param name="month-genitive">
                <xsl:call-template name="Month">
                    <xsl:with-param name="month-number" select="format-dateTime($start-ts, '[M1]', 'en', 'AD', '')"/>
                </xsl:call-template>
            </xsl:with-param>
        </xsl:call-template>
    </xsl:template>

    <!-- Links (some are valid in specific cases only) -->

    <xsl:variable name="calendar-url" select="message/calendar-url"/>

    <xsl:variable name="event-edit-link">
        <xsl:value-of select="$calendar-url"/>
        <xsl:text><![CDATA[/event/]]></xsl:text>
        <xsl:value-of select="$query-uid-param"/>
        <xsl:text><![CDATA[event_id=]]></xsl:text><xsl:value-of select="$event-id"/>
        <xsl:text><![CDATA[&show_date=]]></xsl:text><xsl:value-of select="$start-date"/>
        <xsl:text><![CDATA[&view_type=week]]></xsl:text>
    </xsl:variable>

    <xsl:variable name="event-details-link">
        <xsl:value-of select="$calendar-url"/>
        <xsl:text><![CDATA[/event/]]></xsl:text>
        <xsl:value-of select="$query-uid-param"/>
        <xsl:text><![CDATA[private_token=]]></xsl:text><xsl:value-of select="$ptk"/>
        <xsl:text><![CDATA[&event_id=]]></xsl:text><xsl:value-of select="$event-id"/>
        <xsl:text><![CDATA[&show_date=]]></xsl:text><xsl:value-of select="$start-date"/>
    </xsl:variable>

    <xsl:variable name="event-page-link">
        <xsl:value-of select="$calendar-url"/>
        <xsl:text><![CDATA[/event]]></xsl:text>
        <xsl:value-of select="$query-uid-param"/>
        <xsl:text><![CDATA[event_id=]]></xsl:text><xsl:value-of select="$event-id"/>
    </xsl:variable>

    <xsl:variable name="event-accept-link">
        <xsl:value-of select="$calendar-url"/>
        <xsl:text><![CDATA[/api/add-event-invitation]]></xsl:text>
        <xsl:value-of select="$query-uid-param"/>
        <xsl:text><![CDATA[private_token=]]></xsl:text><xsl:value-of select="$ptk"/>
        <xsl:text><![CDATA[&event_id=]]></xsl:text><xsl:value-of select="$event-id"/>
        <xsl:text><![CDATA[&decision=yes]]></xsl:text>
        <xsl:text><![CDATA[&from_mail=1]]></xsl:text>
    </xsl:variable>

    <xsl:variable name="event-maybe-link">
        <xsl:value-of select="$calendar-url"/>
        <xsl:text><![CDATA[/api/add-event-invitation]]></xsl:text>
        <xsl:value-of select="$query-uid-param"/>
        <xsl:text><![CDATA[private_token=]]></xsl:text><xsl:value-of select="$ptk"/>
        <xsl:text><![CDATA[&event_id=]]></xsl:text><xsl:value-of select="$event-id"/>
        <xsl:text><![CDATA[&decision=maybe]]></xsl:text>
        <xsl:text><![CDATA[&from_mail=1]]></xsl:text>
    </xsl:variable>

    <xsl:variable name="event-decline-link">
        <xsl:value-of select="$calendar-url"/>
        <xsl:text><![CDATA[/api/add-event-invitation]]></xsl:text>
        <xsl:value-of select="$query-uid-param"/>
        <xsl:text><![CDATA[private_token=]]></xsl:text><xsl:value-of select="$ptk"/>
        <xsl:text><![CDATA[&event_id=]]></xsl:text><xsl:value-of select="$event-id"/>
        <xsl:text><![CDATA[&decision=no]]></xsl:text>
    </xsl:variable>

    <xsl:variable name="go-calendar-link">
        <xsl:value-of select="$calendar-url"/>
        <xsl:text><![CDATA[/]]></xsl:text>
        <xsl:value-of select="$query-uid-param"/>
        <xsl:text><![CDATA[show_date=]]></xsl:text><xsl:value-of select="$start-date"/>
    </xsl:variable>

    <xsl:variable name="refuse-receiving-event-emails-link"><xsl:value-of select="$calendar-url"/><xsl:text>/tune</xsl:text><xsl:value-of select="$query-uid-single-param"/></xsl:variable>
    <xsl:variable name="refuse-receiving-todo-lists-link"><xsl:value-of select="$refuse-receiving-event-emails-link"/></xsl:variable>

    <xsl:variable name="is-decision-yes" select="message/decision = 'yes'"/>
    <xsl:variable name="is-decision-maybe" select="message/decision = 'maybe'"/>

    <!-- Html specific -->

    <xsl:template name="text-part-html-common">
        <html>
        <head>
            <meta http-equiv="Content-type" content="text/html; charset=utf-8" />
        </head>
        <body link="#1952ce" alink="red" style="line-height: 1.4">
            <xsl:call-template name="text-part-html-custom"/>
            <xsl:call-template name="footer-html"/>
        </body>
        </html>
    </xsl:template>

    <xsl:template name="footer-html">
        <table cellpadding="4" width="100%">
        <tr>
            <td>
                <hr size="1" noshade="noshade" color="#cccccc" style="border: 0 hidden; border-top: 1px solid #cccccc; height: 0; margin-top: 30px;"/>
                <font size="1" face="Verdana, sans-serif" color="#9a9a9a">
                    <xsl:call-template name="i18n:calendar.emails2.Footer">
                        <xsl:with-param name="Yandex-calendar">
                            <a style="color: #9a9a9a" href="{concat($calendar-url, $query-uid-single-param)}"><xsl:call-template name="i18n:calendar.emails2.Yandex-calendar"/></a>
                        </xsl:with-param>
                        <xsl:with-param name="refuse-them">
                            <a style="color: #9a9a9a" href="{$refuse-receiving-event-emails-link}"><xsl:call-template name="i18n:calendar.emails2.refuse-them"/></a>
                        </xsl:with-param>
                        <xsl:with-param name="copyright-period">
                            <xsl:call-template name="copyright-period"/>
                        </xsl:with-param>
                        <xsl:with-param name="Yandex">
                            <a style="color: #9a9a9a" href="http://www.yandex.ru"><xsl:call-template name="i18n:calendar.emails2.Yandex"/></a>
                        </xsl:with-param>
                    </xsl:call-template>
                </font>
            </td>
        </tr>
        </table>
    </xsl:template>

    <xsl:template match="event-description-xml | event-description-text" mode="html">
        <tr>
            <td valign="top">
                <font color="#a2a2a2" face="Arial,sans-serif" size="3">
                    <b>
                        <xsl:call-template name="i18n:calendar.emails2.Description"/>
                    </b>
                </font>
            </td>
            <td width="5"/>
            <td>
                <xsl:if test="//event-changes/description = 1">
                    <font color="#349900" face="Arial,sans-serif" size="3">
                        <xsl:call-template name="i18n:calendar.emails2.Becomes"/>:<br/>
                    </font>
                </xsl:if>
                <font face="Arial,sans-serif" size="3">
                    <xsl:apply-templates mode="html"/>
                </font>
            </td>
        </tr>
    </xsl:template>

    <xsl:template match="event-location[not(location-xml) and not(resources) and not(missed-resources)]" mode="html"/>

    <xsl:template match="event-location" mode="html">
        <tr>
            <td valign="top">
                <font color="#a2a2a2" face="Arial,sans-serif" size="3">
                    <b>
                        <xsl:call-template name="i18n:calendar.emails2.Where"/>
                    </b>
                </font>
            </td>
            <td width="5"/>
            <td>
                <xsl:if test="//event-changes/location = 1">
                    <font color="#349900" face="Arial,sans-serif" size="3">
                        <xsl:call-template name="i18n:calendar.emails2.Becomes"/>:&nbsp;
                    </font>
                </xsl:if>
                <font face="Arial,sans-serif" size="3">
                    <xsl:apply-templates select="resources" mode="html"/>
                    <xsl:apply-templates select="missed-resources" mode="html"/>
                    <xsl:apply-templates select="road-map-offices" mode="html"/>
                    <xsl:if test="location-xml and (resources or missed-resources or road-map-offices/office)">
                        <div style="margin-top: 8px"/>
                    </xsl:if>
                    <xsl:apply-templates select="location-xml" mode="html"/>
                </font>
            </td>
        </tr>
    </xsl:template>

    <xsl:variable name="out-location-resources-phones" select="false()"/>

    <xsl:template match="event-location/resources" mode="html">
        <xsl:for-each select="resource">
            <xsl:if test="href"><a href="{href}"><xsl:value-of select="name"/></a></xsl:if>
            <xsl:if test="not(href)"><xsl:value-of select="name"/></xsl:if>

            <xsl:variable name="phones">
                <xsl:if test="phone">
                    <x>
                        <xsl:call-template name="i18n:calendar.emails2.phone"/>
                        <xsl:text>: </xsl:text>
                        <xsl:value-of select="phone"/>
                    </x>
                </xsl:if>
                <xsl:if test="video">
                    <x>
                        <xsl:call-template name="i18n:calendar.emails2.video"/>
                        <xsl:text>: </xsl:text>
                        <xsl:value-of select="video"/>
                    </x>
                </xsl:if>
                <xsl:if test="not(phone) and not(video)">
                    <x><xsl:call-template name="i18n:calendar.emails2.no-phone"/></x>
                </xsl:if>
            </xsl:variable>

            <xsl:if test="$out-location-resources-phones">
                <xsl:text> </xsl:text>
                <xsl:for-each select="$phones/x">
                    <xsl:value-of select="."/>
                    <xsl:if test="position() != last()"><xsl:text>, </xsl:text></xsl:if>
                </xsl:for-each>
                <xsl:if test="position() != last()"><br/></xsl:if>
            </xsl:if>
            <xsl:if test="not($out-location-resources-phones)">
                <xsl:if test="position() != last() or ../../missed-resources/resource"><xsl:text>, </xsl:text></xsl:if>
            </xsl:if>
        </xsl:for-each>
    </xsl:template>

    <xsl:template match="event-location/missed-resources" mode="html">
        <xsl:for-each select="resource">
            <del><xsl:value-of select="name"/></del>

            <xsl:if test="not($out-location-resources-phones)">
                <xsl:if test="position() != last()"><xsl:text>, </xsl:text></xsl:if>
            </xsl:if>
        </xsl:for-each>
    </xsl:template>

    <xsl:template match="event-location/road-map-offices" mode="html">
        <xsl:if test="office">
            <div style="margin-top: 8px">
                <xsl:call-template name="i18n:calendar.emails2.address-and-directions"/>
                <xsl:for-each select="office">
                    <xsl:choose>
                        <xsl:when test=". = 'avrora'">
                            <a href="https://yandex.ru/company/contacts/moscow/"><xsl:call-template name="i18n:calendar.emails2.directions-avrora"/></a>
                        </xsl:when>
                        <xsl:when test=". = 'redrose'">
                            <a href="https://yandex.ru/company/contacts/moscow/"><xsl:call-template name="i18n:calendar.emails2.directions-redrose"/></a>
                        </xsl:when>
                        <xsl:when test=". = 'rrs'">
                            <a href="https://yandex.ru/company/contacts/moscow/"><xsl:call-template name="i18n:calendar.emails2.directions-rrs"/></a>
                        </xsl:when>
                        <xsl:when test=". = 'rrm'">
                            <a href="https://yandex.ru/company/contacts/moscow/"><xsl:call-template name="i18n:calendar.emails2.directions-rrm"/></a>
                        </xsl:when>
                        <xsl:when test=". = 'mskoko'">
                            <a href="https://yandex.ru/company/contacts/moscow/"><xsl:call-template name="i18n:calendar.emails2.directions-mskoko"/></a>
                        </xsl:when>
                        <xsl:when test=". = 'lotteplaza'">
                            <a href="https://yandex.ru/company/contacts/moscow/"><xsl:call-template name="i18n:calendar.emails2.directions-lotteplaza"/></a>
                        </xsl:when>
                        <xsl:when test=". = 'amalteya'">
                            <a href="https://yandex.ru/company/contacts/moscow/"><xsl:call-template name="i18n:calendar.emails2.directions-amalteya"/></a>
                        </xsl:when>
                        <xsl:when test=". = 'spb'">
                            <a href="https://yandex.ru/company/contacts/spb/"><xsl:call-template name="i18n:calendar.emails2.directions-spb"/></a>
                        </xsl:when>
                        <xsl:when test=". = 'eburg'">
                            <a href="https://yandex.ru/company/contacts/ekaterinburg/"><xsl:call-template name="i18n:calendar.emails2.directions-eburg"/></a>
                        </xsl:when>
                        <xsl:when test=". = 'nsk'">
                            <a href="https://yandex.ru/company/contacts/nsk/"><xsl:call-template name="i18n:calendar.emails2.directions-nsk"/></a>
                        </xsl:when>
                        <xsl:when test=". = 'kzn'">
                            <a href="https://yandex.ru/company/contacts/kazan/"><xsl:call-template name="i18n:calendar.emails2.directions-kzn"/></a>
                        </xsl:when>
                        <xsl:when test=". = 'Innopolis'">
                            <a href="https://yandex.ru/company/contacts/innopolis/"><xsl:call-template name="i18n:calendar.emails2.directions-innopolis"/></a>
                        </xsl:when>
                        <xsl:when test=". = 'rnd'">
                            <a href="https://yandex.ru/company/contacts/rostov/"><xsl:call-template name="i18n:calendar.emails2.directions-rnd"/></a>
                        </xsl:when>
                        <xsl:when test=". = 'nnlob'">
                            <a href="https://yandex.ru/company/contacts/nnovgorod/"><xsl:call-template name="i18n:calendar.emails2.directions-nnlob"/></a>
                        </xsl:when>
                        <xsl:when test=". = 'simf'">
                            <a href="https://yandex.ru/company/contacts/simferopol/"><xsl:call-template name="i18n:calendar.emails2.directions-simf"/></a>
                        </xsl:when>
                        <xsl:when test=". = 'freshlaza'">
                            <a href="https://yandex.ru/company/contacts/vladivostok/"><xsl:call-template name="i18n:calendar.emails2.directions-freshlaza"/></a>
                        </xsl:when>
                        <xsl:when test=". = 'admiral'">
                            <a href="https://yandex.ru/company/contacts/krasnodar/"><xsl:call-template name="i18n:calendar.emails2.directions-admiral"/></a>
                        </xsl:when>
                        <xsl:when test=". = 'millennium'">
                            <a href="https://yandex.ru/company/contacts/samara/"><xsl:call-template name="i18n:calendar.emails2.directions-millennium"/></a>
                        </xsl:when>
                        <xsl:when test=". = 'chel'">
                            <a href="https://yandex.ru/company/contacts/chelyabinsk/"><xsl:call-template name="i18n:calendar.emails2.directions-chel"/></a>
                        </xsl:when>
                        <xsl:when test=". = 'pgrand'">
                            <a href="https://yandex.ru/company/contacts/perm/"><xsl:call-template name="i18n:calendar.emails2.directions-pgrand"/></a>
                        </xsl:when>
                        <xsl:when test=". = 'tt'">
                            <a href="https://yandex.ru/company/contacts/tula/"><xsl:call-template name="i18n:calendar.emails2.directions-tt"/></a>
                        </xsl:when>
                        <xsl:when test=". = 'sochi'">
                            <a href="https://yandex.ru/company/contacts/sochi/"><xsl:call-template name="i18n:calendar.emails2.directions-sochi"/></a>
                        </xsl:when>
                        <xsl:when test=". = 'uap'">
                            <a href="https://yandex.ru/company/contacts/ufa/"><xsl:call-template name="i18n:calendar.emails2.directions-uap"/></a>
                        </xsl:when>
                        <xsl:when test=". = 'balans'">
                            <a href="https://yandex.ru/company/contacts/krasnoyarsk/"><xsl:call-template name="i18n:calendar.emails2.directions-balans"/></a>
                        </xsl:when>
                        <xsl:when test=". = 'ta'">
                            <a href="https://yandex.ru/company/contacts/tyumen/"><xsl:call-template name="i18n:calendar.emails2.directions-ta"/></a>
                        </xsl:when>
                        <xsl:when test=". = 'vrmsk'">
                            <a href="https://yandex.ru/company/contacts/voronezh/"><xsl:call-template name="i18n:calendar.emails2.directions-vrmsk"/></a>
                        </xsl:when>
                        <xsl:otherwise/>
                    </xsl:choose>
                    <xsl:if test="position() != last()"><xsl:text>, </xsl:text></xsl:if>
                </xsl:for-each>
                <xsl:text>)</xsl:text>
            </div>
        </xsl:if>
    </xsl:template>

    <xsl:template match="event-description-xml/a | event-location/location-xml/a" mode="html">
        <a href="{@href}"><xsl:value-of select="."/></a>
    </xsl:template>

    <xsl:template match="event-description-xml/br | event-location/location-xml/br" mode="html">
        <br/>
    </xsl:template>

    <xsl:template match="rep-hints" mode="html">
        <font color="#a6a6a6">
            <xsl:call-template name="rep-hints-text"/>
        </font>
    </xsl:template>

    <xsl:template match="organizer-nick" mode="html">
        <tr>
            <td valign="top">
                <font color="#a2a2a2" face="Arial,sans-serif" size="3">
                    <b><xsl:call-template name="i18n:calendar.emails2.Organizer"/></b>
                </font>
            </td>
            <td width="5"></td>
            <td>
                <xsl:if test="//event-changes/organizer = 1">
                    <font color="#349900" face="Arial,sans-serif" size="3">
                        <xsl:call-template name="i18n:calendar.emails2.Becomes"/>:&nbsp;
                    </font>
                </xsl:if>
                <font face="Arial,sans-serif" size="3">
                    <xsl:apply-templates mode="html"/>
                </font>
            </td>
        </tr>
    </xsl:template>

    <xsl:template match="guests" mode="html">
        <xsl:apply-templates select="required-guests" mode="guests-row">
            <xsl:with-param name="row-name"><xsl:call-template name="i18n:calendar.emails2.Invited"/></xsl:with-param>
            <xsl:with-param name="show-who-goes" select="true()"/>
        </xsl:apply-templates>
        <xsl:apply-templates select="optional-guests" mode="guests-row">
            <xsl:with-param name="row-name"><xsl:call-template name="i18n:calendar.emails2.Invited-optional"/></xsl:with-param>
            <xsl:with-param name="show-who-goes" select="true()"/>
        </xsl:apply-templates>
    </xsl:template>

    <xsl:template match="guests-changes" mode="html">
        <xsl:apply-templates select="new-required-guests" mode="guests-row">
            <xsl:with-param name="row-name"><xsl:call-template name="i18n:calendar.emails2.New-invitees"/></xsl:with-param>
            <xsl:with-param name="show-who-goes" select="count(rem-required-guests) = 0"/>
        </xsl:apply-templates>
        <xsl:apply-templates select="new-optional-guests" mode="guests-row">
            <xsl:with-param name="row-name"><xsl:call-template name="i18n:calendar.emails2.New-optional-invitees"/></xsl:with-param>
            <xsl:with-param name="show-who-goes" select="count(rem-optional-guests) = 0"/>
        </xsl:apply-templates>

        <xsl:apply-templates select="rem-required-guests" mode="guests-row">
            <xsl:with-param name="row-name"><xsl:call-template name="i18n:calendar.emails2.Removed-invitees"/></xsl:with-param>
            <xsl:with-param name="show-who-goes" select="true()"/>
        </xsl:apply-templates>
        <xsl:apply-templates select="rem-optional-guests" mode="guests-row">
            <xsl:with-param name="row-name"><xsl:call-template name="i18n:calendar.emails2.Removed-optional-invitees"/></xsl:with-param>
            <xsl:with-param name="show-who-goes" select="true()"/>
        </xsl:apply-templates>
    </xsl:template>

    <xsl:template match="required-guests|optional-guests|new-required-guests|new-optional-guests|rem-required-guests|rem-optional-guests" mode="guests-row">
        <xsl:param name="row-name"/>
        <xsl:param name="show-who-goes"/>

        <tr>
            <td valign="top">
                <font color="#a2a2a2" face="Arial,sans-serif" size="3">
                    <b><xsl:value-of select="$row-name"/></b>
                </font>
            </td>
            <td width="5"/>
            <td>
                <xsl:choose>
                    <xsl:when test="@total > 20">
                        <font face="Arial,sans-serif" size="3">
                            <xsl:apply-templates select="guest[15 >= position()]" mode="html"/>
                        </font>
                        <a href="{$event-details-link}">
                            <font face="Verdana,sans-serif" size="1">
                                <xsl:call-template name="i18n:calendar.emails2.And-more-invitees">
                                    <xsl:with-param name="number"><xsl:value-of select="@total - 15"/></xsl:with-param>
                                </xsl:call-template>
                                <xsl:text>.&nbsp;</xsl:text>
                                <xsl:call-template name="i18n:calendar.emails2.See-who-goes"/>
                            </font>
                        </a>
                    </xsl:when>
                    <xsl:otherwise>
                        <font face="Arial,sans-serif" size="3">
                            <xsl:apply-templates select="guest" mode="html"/>
                        </font>
                        <xsl:if test="$show-who-goes">
                            <a href="{$event-details-link}">
                                <font face="Verdana,sans-serif" size="1">
                                    <xsl:call-template name="i18n:calendar.emails2.See-who-goes"/>
                                </font>
                            </a>
                        </xsl:if>
                    </xsl:otherwise>
                </xsl:choose>
            </td>
        </tr>
    </xsl:template>

    <xsl:template match="guest" mode="html">
        <xsl:call-template name="nick-style-html"/><br/>
    </xsl:template>


    <xsl:template match="nick | sender-nick" mode="html">
        <xsl:call-template name="nick-style-html"/>
    </xsl:template>

    <xsl:template name="nick-style-html">
        <xsl:value-of select="."/>
    </xsl:template>


    <xsl:template name="event-decision-actions-bar-html">
        <table cellpadding="4" width="100%">
        <tr>
            <td bgcolor="#e3eafd">
                <table cellspacing="0" cellpadding="5">
                <tr>
                    <xsl:if test="not($is-decision-yes)">
                        <xsl:call-template name="decision-action-html">
                            <xsl:with-param name="link" select="$event-accept-link"/>
                            <xsl:with-param name="text"><xsl:call-template name="i18n:calendar.emails2.I-attend"/></xsl:with-param>
                        </xsl:call-template>
                    </xsl:if>
                    <xsl:if test="not($is-decision-yes) and not($is-decision-maybe)">
                        <xsl:call-template name="decision-action-html">
                            <xsl:with-param name="link" select="$event-maybe-link"/>
                            <xsl:with-param name="text"><xsl:call-template name="i18n:calendar.emails2.I-maybe-attend"/></xsl:with-param>
                        </xsl:call-template>
                    </xsl:if>
                    <xsl:if test="for-organizer-or-creator != '1'"> <!-- XXX not($is-decision-no) -->
                        <xsl:call-template name="decision-action-html">
                            <xsl:with-param name="link" select="$event-decline-link"/>
                            <xsl:with-param name="text"><xsl:call-template name="i18n:calendar.emails2.I-dont-attend"/></xsl:with-param>
                        </xsl:call-template>
                    </xsl:if>
                </tr>
                </table>
            </td>
        </tr>
        </table>
    </xsl:template>

    <xsl:template name="decision-action-html">
        <xsl:param name="link"/>
        <xsl:param name="text"/>
        <td style="padding: 0 7px 1px"><font size="3" face="Arial,sans-serif"><b><a href="{$link}"><xsl:value-of select="$text"/></a></b></font></td>
    </xsl:template>


    <xsl:template name="event-and-edit-link-html">
        <a href="{$event-edit-link}"><xsl:value-of select="$event-name"/></a>
    </xsl:template>


    <!-- Plain text specific -->

    <xsl:template name="text-part-plain-common">
        <xsl:call-template name="text-part-plain-custom"/>
        <xsl:call-template name="footer-plain"/>
    </xsl:template>

    <xsl:template name="footer-plain">
        <xsl:text>&lf;-- &lf;</xsl:text>
        <xsl:call-template name="i18n:calendar.emails2.Footer">
            <xsl:with-param name="Yandex-calendar">
                <xsl:call-template name="i18n:calendar.emails2.Yandex-calendar"/>
                <xsl:text> (</xsl:text><xsl:value-of select="concat($calendar-url, $query-uid-single-param)"/><xsl:text>)</xsl:text>
            </xsl:with-param>
            <xsl:with-param name="refuse-them">
                <xsl:call-template name="i18n:calendar.emails2.refuse-them"/>
                <xsl:text> (</xsl:text><xsl:value-of select="$refuse-receiving-event-emails-link"/><xsl:text>)</xsl:text>
            </xsl:with-param>
            <xsl:with-param name="copyright-period">
                <xsl:call-template name="copyright-period"/>
            </xsl:with-param>
            <xsl:with-param name="Yandex">
                <xsl:call-template name="i18n:calendar.emails2.Yandex"/>
            </xsl:with-param>
        </xsl:call-template>
    </xsl:template>

    <xsl:template match="event-description-text" mode="plain">
        <xsl:if test="//event-changes/description = 1">
            <xsl:call-template name="i18n:calendar.emails2.Becomes"/>:&nbsp;
        </xsl:if>
        <xsl:call-template name="i18n:calendar.emails2.Description"/>
        <xsl:text>:&nbsp;</xsl:text>
        <xsl:value-of select="."/>
        <xsl:text>&lf;</xsl:text>
    </xsl:template>

    <xsl:template match="event-location[not(location-text) and not(resources)]" mode="plain"/>

    <xsl:template match="event-location" mode="plain">
        <xsl:if test="//event-changes/location = 1">
            <xsl:call-template name="i18n:calendar.emails2.Becomes"/>:&nbsp;
        </xsl:if>
        <xsl:call-template name="i18n:calendar.emails2.Where"/>
        <xsl:text>:&nbsp;</xsl:text>
        <xsl:apply-templates select="resources" mode="plain"/>
        <xsl:if test="location-text and resources">
            <xsl:text>, </xsl:text>
        </xsl:if>
        <xsl:apply-templates select="location-text" mode="plain"/>
        <xsl:apply-templates select="road-map-offices" mode="plain"/>
        <xsl:text>&lf;</xsl:text>
    </xsl:template>

    <xsl:template match="event-location/location-text" mode="plain">
        <xsl:value-of select="."/>
    </xsl:template>

    <xsl:template match="event-location/resources" mode="plain">
        <xsl:for-each select="resource">
            <xsl:value-of select="name"/>
            <xsl:if test="position() != last()">
                <xsl:text>, </xsl:text>
            </xsl:if>
        </xsl:for-each>
    </xsl:template>

    <xsl:template match="event-location/road-map-offices" mode="plain">
        <xsl:if test="office">
            <xsl:text>&lf;</xsl:text>
            <xsl:call-template name="i18n:calendar.emails2.address-and-directions"/>
            <xsl:for-each select="office">
                <xsl:choose>
                    <xsh:when test=". = 'avrora'">
                        <xsl:call-template name="i18n:calendar.emails2.directions-avrora"/>
                        <xsl:text>: https://yandex.ru/company/contacts/moscow/</xsl:text>
                    </xsh:when>
                    <xsl:when test=". = 'redrose'">
                        <xsl:call-template name="i18n:calendar.emails2.directions-redrose"/>
                        <xsl:text>: https://yandex.ru/company/contacts/moscow/</xsl:text>
                    </xsl:when>
                    <xsl:when test=". = 'rrs'">
                        <xsl:call-template name="i18n:calendar.emails2.directions-rrs"/>
                        <xsl:text>: https://yandex.ru/company/contacts/moscow/</xsl:text>
                    </xsl:when>
                    <xsl:when test=". = 'rrm'">
                        <xsl:call-template name="i18n:calendar.emails2.directions-rrm"/>
                        <xsl:text>: https://yandex.ru/company/contacts/moscow/</xsl:text>
                    </xsl:when>
                    <xsl:when test=". = 'mskoko'">
                        <xsl:call-template name="i18n:calendar.emails2.directions-mskoko"/>
                        <xsl:text>: https://yandex.ru/company/contacts/moscow/</xsl:text>
                    </xsl:when>
                    <xsl:when test=". = 'lotteplaza'">
                        <xsl:call-template name="i18n:calendar.emails2.directions-lotteplaza"/>
                        <xsl:text>: https://yandex.ru/company/contacts/moscow/</xsl:text>
                    </xsl:when>
                    <xsl:when test=". = 'amalteya'">
                        <xsl:call-template name="i18n:calendar.emails2.directions-amalteya"/>
                        <xsl:text>: https://yandex.ru/company/contacts/moscow/</xsl:text>
                    </xsl:when>
                    <xsl:when test=". = 'spb'">
                        <xsl:call-template name="i18n:calendar.emails2.directions-spb"/>
                        <xsl:text>: https://yandex.ru/company/contacts/spb/</xsl:text>
                    </xsl:when>
                    <xsl:when test=". = 'eburg'">
                        <xsl:call-template name="i18n:calendar.emails2.directions-eburg"/>
                        <xsl:text>: https://yandex.ru/company/contacts/ekaterinburg/</xsl:text>
                    </xsl:when>
                    <xsl:when test=". = 'nsk'">
                        <xsl:call-template name="i18n:calendar.emails2.directions-nsk"/>
                        <xsl:text>: https://yandex.ru/company/contacts/nsk/</xsl:text>
                    </xsl:when>
                    <xsl:when test=". = 'kzn'">
                        <xsl:call-template name="i18n:calendar.emails2.directions-kzn"/>
                        <xsl:text>: https://yandex.ru/company/contacts/kazan/</xsl:text>
                    </xsl:when>
                    <xsl:when test=". = 'Innopolis'">
                        <xsl:call-template name="i18n:calendar.emails2.directions-innopolis"/>
                        <xsl:text>: https://yandex.ru/company/contacts/innopolis/</xsl:text>
                    </xsl:when>
                    <xsl:when test=". = 'rnd'">
                        <xsl:call-template name="i18n:calendar.emails2.directions-rnd"/>
                        <xsl:text>: https://yandex.ru/company/contacts/rostov/</xsl:text>
                    </xsl:when>
                    <xsl:when test=". = 'nnlob'">
                        <xsl:call-template name="i18n:calendar.emails2.directions-nnlob"/>
                        <xsl:text>: https://yandex.ru/company/contacts/nnovgorod/</xsl:text>
                    </xsl:when>
                    <xsl:when test=". = 'simf'">
                        <xsl:call-template name="i18n:calendar.emails2.directions-simf"/>
                        <xsl:text>: https://yandex.ru/company/contacts/simferopol/</xsl:text>
                    </xsl:when>
                    <xsl:when test=". = 'freshlaza'">
                        <xsl:call-template name="i18n:calendar.emails2.directions-freshlaza"/>
                        <xsl:text>: https://yandex.ru/company/contacts/vladivostok/</xsl:text>
                    </xsl:when>
                    <xsl:when test=". = 'admiral'">
                        <xsl:call-template name="i18n:calendar.emails2.directions-admiral"/>
                        <xsl:text>: https://yandex.ru/company/contacts/krasnodar/</xsl:text>
                    </xsl:when>
                    <xsl:when test=". = 'millennium'">
                        <xsl:call-template name="i18n:calendar.emails2.directions-millennium"/>
                        <xsl:text>: https://yandex.ru/company/contacts/samara/</xsl:text>
                    </xsl:when>
                    <xsl:when test=". = 'chel'">
                        <xsl:call-template name="i18n:calendar.emails2.directions-chel"/>
                        <xsl:text>: https://yandex.ru/company/contacts/chelyabinsk/</xsl:text>
                    </xsl:when>
                    <xsl:when test=". = 'pgrand'">
                        <xsl:call-template name="i18n:calendar.emails2.directions-pgrand"/>
                        <xsl:text>: https://yandex.ru/company/contacts/perm/</xsl:text>
                    </xsl:when>
                    <xsl:when test=". = 'tt'">
                        <xsl:call-template name="i18n:calendar.emails2.directions-tt"/>
                        <xsl:text>: https://yandex.ru/company/contacts/tula/</xsl:text>
                    </xsl:when>
                    <xsl:when test=". = 'sochi'">
                        <xsl:call-template name="i18n:calendar.emails2.directions-sochi"/>
                        <xsl:text>: https://yandex.ru/company/contacts/sochi/</xsl:text>
                    </xsl:when>
                    <xsl:when test=". = 'uap'">
                        <xsl:call-template name="i18n:calendar.emails2.directions-uap"/>
                        <xsl:text>: https://yandex.ru/company/contacts/ufa/</xsl:text>
                    </xsl:when>
                    <xsl:when test=". = 'balans'">
                        <xsl:call-template name="i18n:calendar.emails2.directions-balans"/>
                        <xsl:text>: https://yandex.ru/company/contacts/krasnoyarsk/</xsl:text>
                    </xsl:when>
                    <xsl:when test=". = 'ta'">
                        <xsl:call-template name="i18n:calendar.emails2.directions-ta"/>
                        <xsl:text>: https://yandex.ru/company/contacts/tyumen/</xsl:text>
                    </xsl:when>
                    <xsl:when test=". = 'vrmsk'">
                        <xsl:call-template name="i18n:calendar.emails2.directions-vrmsk"/>
                        <xsl:text>: https://yandex.ru/company/contacts/voronezh/</xsl:text>
                    </xsl:when>
                    <xsl:otherwise/>
                </xsl:choose>
                <xsl:if test="position() != last()"><xsl:text>, </xsl:text></xsl:if>
            </xsl:for-each>
            <xsl:text>)</xsl:text>
            <xsl:text>&lf;</xsl:text>
        </xsl:if>
    </xsl:template>

    <xsl:template match="rep-hints" mode="plain">
        <xsl:call-template name="rep-hints-text"/>
    </xsl:template>

    <xsl:template match="organizer-nick" mode="plain">
        <xsl:if test="//event-changes/organizer = 1">
            <xsl:call-template name="i18n:calendar.emails2.Becomes"/>:&nbsp;
        </xsl:if>
        <xsl:call-template name="i18n:calendar.emails2.Organizer"/>
        <xsl:text>:&nbsp;</xsl:text>
        <xsl:apply-templates mode="plain"/>
        <xsl:text>&lf;</xsl:text>
    </xsl:template>

    <xsl:template match="guests" mode="plain">
        <xsl:if test="//event-changes/guests = 1">
            <xsl:call-template name="i18n:calendar.emails2.Becomes"/>:&nbsp;
        </xsl:if>
        <xsl:call-template name="i18n:calendar.emails2.Invited"/>
        <xsl:text>:&lf;</xsl:text>

        <xsl:choose>
            <xsl:when test="@total > 20">
                <xsl:apply-templates select="guest[15 >= position()]" mode="plain"/>

                <xsl:text>&lf;</xsl:text>
                <xsl:call-template name="i18n:calendar.emails2.And-more-invitees">
                    <xsl:with-param name="number"><xsl:value-of select="@total - 15"/></xsl:with-param>
                </xsl:call-template>
                <xsl:text>.&nbsp;</xsl:text>
                <xsl:call-template name="i18n:calendar.emails2.See-who-goes"/>
                <xsl:text>:&lf;</xsl:text>
                <xsl:value-of select="$event-details-link"/>
                <xsl:text>&lf;</xsl:text>
            </xsl:when>
            <xsl:otherwise>
                <xsl:apply-templates select="guest" mode="plain"/>

                <xsl:text>&lf;</xsl:text>
                <xsl:call-template name="i18n:calendar.emails2.See-who-goes"/>
                <xsl:text>:&lf;</xsl:text>
                <xsl:value-of select="$event-details-link"/>
                <xsl:text>&lf;</xsl:text>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="guest" mode="plain">
        <xsl:text>&nbsp;&nbsp;</xsl:text>
        <xsl:call-template name="nick-style-plain"/>
        <xsl:text>&lf;</xsl:text>
    </xsl:template>

    <xsl:template match="nick | sender-nick" mode="plain">
        <xsl:call-template name="nick-style-plain"/>
    </xsl:template>

    <xsl:template name="nick-style-plain">
        <xsl:value-of select="."/>
    </xsl:template>


    <xsl:template name="event-decision-actions-bar-plain">
        <xsl:if test="not($is-decision-yes)">
            <xsl:call-template name="decision-action-plain">
                <xsl:with-param name="link" select="$event-accept-link"/>
                <xsl:with-param name="text"><xsl:call-template name="i18n:calendar.emails2.I-attend"/></xsl:with-param>
            </xsl:call-template>
        </xsl:if>
        <xsl:if test="not($is-decision-yes) and not($is-decision-maybe)">
            <xsl:call-template name="decision-action-plain">
                <xsl:with-param name="link" select="$event-maybe-link"/>
                <xsl:with-param name="text"><xsl:call-template name="i18n:calendar.emails2.I-maybe-attend"/></xsl:with-param>
            </xsl:call-template>
        </xsl:if>
        <xsl:if test="for-organizer-or-creator != '1'"> <!-- XXX not($is-decision-no) -->
            <xsl:call-template name="decision-action-plain">
                <xsl:with-param name="link" select="$event-decline-link"/>
                <xsl:with-param name="text"><xsl:call-template name="i18n:calendar.emails2.I-dont-attend"/></xsl:with-param>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>

    <xsl:template name="decision-action-plain">
        <xsl:param name="link"/>
        <xsl:param name="text"/>
        <xsl:value-of select="$text"/><xsl:text>:&nbsp;</xsl:text>
        <xsl:value-of select="$link"/><xsl:text>&lf;</xsl:text>
    </xsl:template>

    <xsl:template name="event-edit-link-lf-plain">
        <xsl:if test="$is-decision-yes"> <!-- XXX and layer-id -->
            <xsl:value-of select="$event-edit-link"/>
            <xsl:text>&lf;</xsl:text>
        </xsl:if>
    </xsl:template>

    <xsl:template name="i18n:tanker.days.acc"> <!-- tanker does not provide this selector (see tanker.days.xsl) -->
        <xsl:param name="day"/>

        <xsl:choose>
            <xsl:when test="$day = 1"><xsl:call-template name="i18n:tanker.days.acc1"/></xsl:when>
            <xsl:when test="$day = 2"><xsl:call-template name="i18n:tanker.days.acc2"/></xsl:when>
            <xsl:when test="$day = 3"><xsl:call-template name="i18n:tanker.days.acc3"/></xsl:when>
            <xsl:when test="$day = 4"><xsl:call-template name="i18n:tanker.days.acc4"/></xsl:when>
            <xsl:when test="$day = 5"><xsl:call-template name="i18n:tanker.days.acc5"/></xsl:when>
            <xsl:when test="$day = 6"><xsl:call-template name="i18n:tanker.days.acc6"/></xsl:when>
            <xsl:when test="$day = 7"><xsl:call-template name="i18n:tanker.days.acc7"/></xsl:when>
        </xsl:choose>
    </xsl:template>

</xsl:stylesheet>

<!-- vim: set encoding=utf-8 ts=4 sw=4 et: -->
