<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet [
        <!ENTITY quot   "&#34;">
        <!ENTITY laquo  "&#171;">
        <!ENTITY raquo  "&#187;">
        <!ENTITY nbsp   "&#160;">
        <!ENTITY copy   "&#169;">
        <!ENTITY rarr   "&#8594;">
        <!ENTITY larr   "&#8592;">
        <!ENTITY hellip "&#8230;">
        <!ENTITY mdash  "&#8212;">
        <!ENTITY copy   "&#169;">
        <!ENTITY lf     "&#x0A;">
        <!ENTITY ndash   "&#x2014;">
        ]>

<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:date="http://exslt.org/dates-and-times"
                xmlns:exsl="http://exslt.org/common"
                xmlns:dp="http://www.dpawson.co.uk"
                xmlns:xdt="http://www.w3.org/2005/02/xpath-datatypes"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                extension-element-prefixes="xs dp exsl date xdt i18n"
                xmlns:i18n="urn:yandex-functions:internationalization">

    <xsl:variable name="to-yandex-user" select="message/to-yandex-user = 1"/>

    <xsl:variable name="language" select="message/language"/>

    <xsl:template match="message" mode="from">
        <xsl:if test="email-from">
            <from address="{email-from}" personal="{sender-nick}" syntax-check="yes" />
            <xsl:if test="email-from != sender-email">
                <reply-to address="{sender-email}" personal="{sender-nick}" syntax-check="yes" />
            </xsl:if>
        </xsl:if>
        <xsl:if test="not(email-from)">
            <from address="{sender-email}" personal="{sender-nick}" syntax-check="yes" />
        </xsl:if>
    </xsl:template>

    <xsl:variable name="to" select="concat('@', substring-after(message/to, '@'))"/>

    <xsl:template name="message-header">
        <xsl:param name="subject"/>

        <header charset="utf-8">
            <xsl:apply-templates select="." mode="from"/>
            <to address="{to}"/>
            <subject text="{$subject}"/>
        </header>
    </xsl:template>


    <xsl:template name="copyright-period">
        <xsl:param name="project-start-year">2007</xsl:param>
        <xsl:variable name="current-year" select="format-dateTime(current-dateTime(), '[Y0001]', 'en', 'AD', '')"/>
        <xsl:text>&copy;&nbsp;</xsl:text>
        <xsl:choose>
            <xsl:when test="$project-start-year = $current-year"><xsl:value-of select="$project-start-year"/></xsl:when>
            <xsl:otherwise><xsl:value-of select="$project-start-year"/>&mdash;<xsl:value-of select="$current-year"/></xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="capitalize">
        <xsl:param name="str"/>
        <xsl:value-of select="concat(upper-case(substring($str, 1, 1)), substring($str, 2))"/>
    </xsl:template>

    <xsl:template name="uncapitalize">
        <xsl:param name="str"/>
        <xsl:value-of select="concat(lower-case(substring($str, 1, 1)), substring($str, 2))"/>
    </xsl:template>

</xsl:stylesheet>
