<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet [
        <!ENTITY quot   "&#34;">
        <!ENTITY laquo  "&#171;">
        <!ENTITY raquo  "&#187;">
        <!ENTITY nbsp   "&#160;">
        <!ENTITY copy   "&#169;">
        <!ENTITY rarr   "&#8594;">
        <!ENTITY larr   "&#8592;">
        <!ENTITY hellip "&#8230;">
        <!ENTITY mdash  "&#8212;">
        <!ENTITY copy   "&#169;">
        <!ENTITY lf     "&#x0A;">
        ]>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:math="http://exslt.org/math"
                extension-element-prefixes="math"
                xmlns:i18n="urn:yandex-functions:internationalization"
                version="1.0">

    <xsl:import href="email-xslts/common-event.xsl" />
    <xsl:output method="html" indent="no"/>


    <xsl:template match="message">
        <message type="mixed">
            <xsl:call-template name="message-header">
                <xsl:with-param name="subject">
                    <xsl:call-template name="Event-cancelled">
                        <xsl:with-param name="event-name" select="$event-name"/>
                    </xsl:call-template>
                </xsl:with-param>
            </xsl:call-template>

            <part id="1" type="alternative">
                <part id="1_1" content-type="text/plain; charset=utf-8">
                    <xsl:call-template name="text-part-plain-common"/>
                </part>
                <part id="1_2" content-type="text/html; charset=utf-8">
                    <xsl:call-template name="text-part-html-common"/>
                </part>
                <xsl:if test="ics">
                    <part id="1_3" content-type="text/calendar; charset=utf-8; method={ics-method}"><xsl:value-of select="ics" /></part>
                </xsl:if>
            </part>
            <xsl:if test="ics">
                <part id="2" content-type="application/ics;charset=utf-8" name="event.ics"><xsl:value-of select="ics" /></part>
            </xsl:if>
        </message>
    </xsl:template>


    <!-- Plain part -->

    <xsl:template name="text-part-plain-custom">
        <xsl:call-template name="User-cancelled-event">
            <xsl:with-param name="sender-name">
                <xsl:apply-templates select="sender-nick" mode="plain"/>
            </xsl:with-param>
            <xsl:with-param name="event-name" select="$event-name"/>
        </xsl:call-template>
        <xsl:text>&lf;</xsl:text>
        <xsl:call-template name="i18n:calendar.emails2.Freed-time"/>
        <xsl:text>:&nbsp;</xsl:text>
        <xsl:call-template name="since-with-no-end-repetition"/>
        <xsl:text>&lf;</xsl:text>
    </xsl:template>


    <!-- Html part -->

    <xsl:template name="text-part-html-custom">
        <table cellpadding="4" width="100%">
        <tr>
            <td bgcolor="f6e9e4">
                <table cellspacing="0" cellpadding="5">
                <tr>
                    <td style="padding: 0 7px 1px">
                        <font size="4" face="Arial,sans-serif">
                            <b>
                                <xsl:call-template name="User-cancelled-event">
                                    <xsl:with-param name="sender-name">
                                        <xsl:apply-templates select="sender-nick" mode="html"/>
                                    </xsl:with-param>
                                    <xsl:with-param name="event-name" select="$event-name"/>
                                </xsl:call-template>
                            </b>
                        </font>
                    </td>
                </tr>
                </table>
            </td>
        </tr>
        <tr>
            <td>
                <font face="Arial,sans-serif" size="3">
                    <xsl:call-template name="i18n:calendar.emails2.Freed-time"/>
                    <xsl:text>:&nbsp;</xsl:text>
                    <xsl:call-template name="since-with-no-end-repetition"/>
                </font>
            </td>
        </tr>
        </table>
    </xsl:template>


    <!--  Common part -->

    <xsl:template name="Event-cancelled">
        <xsl:param name="event-name"/>

        <xsl:choose>
            <xsl:when test="$is-meeting">
                <xsl:call-template name="i18n:calendar.emails2.Meeting-cancelled">
                    <xsl:with-param name="event-name" select="$event-name"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="i18n:calendar.emails2.Event-cancelled">
                    <xsl:with-param name="event-name" select="$event-name"/>
                </xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="User-cancelled-event">
        <xsl:param name="sender-name"/>
        <xsl:param name="event-name"/>

        <xsl:variable name="hide-actor" select="//for-sender = '1' or //hide-actor = '1'"/>
        <xsl:variable name="female-sender" select="//sender-gender = 'F'"/>

        <xsl:if test="$hide-actor">
            <xsl:call-template name="Event-cancelled">
                <xsl:with-param name="event-name" select="$event-name"/>
            </xsl:call-template>
        </xsl:if>
        <xsl:if test="not($hide-actor)">
            <xsl:if test="$is-meeting and not($female-sender)">
                <xsl:call-template name="i18n:calendar.emails2.User-cancelled-meeting">
                    <xsl:with-param name="user-name" select="$sender-name"/>
                    <xsl:with-param name="event-name" select="$event-name"/>
                </xsl:call-template>
            </xsl:if>
            <xsl:if test="not($is-meeting) and not($female-sender)">
                <xsl:call-template name="i18n:calendar.emails2.User-cancelled-event">
                    <xsl:with-param name="user-name" select="$sender-name"/>
                    <xsl:with-param name="event-name" select="$event-name"/>
                </xsl:call-template>
            </xsl:if>
            <xsl:if test="$is-meeting and $female-sender">
                <xsl:call-template name="i18n:calendar.emails2.User-cancelled-meeting_female">
                    <xsl:with-param name="user-name" select="$sender-name"/>
                    <xsl:with-param name="event-name" select="$event-name"/>
                </xsl:call-template>
            </xsl:if>
            <xsl:if test="not($is-meeting) and $female-sender">
                <xsl:call-template name="i18n:calendar.emails2.User-cancelled-event_female">
                    <xsl:with-param name="user-name" select="$sender-name"/>
                    <xsl:with-param name="event-name" select="$event-name"/>
                </xsl:call-template>
            </xsl:if>
        </xsl:if>

    </xsl:template>

</xsl:stylesheet>

<!-- vim: set encoding=utf-8 ts=4 sw=4 et: -->
