<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet [
        <!ENTITY quot   "&#34;">
        <!ENTITY laquo  "&#171;">
        <!ENTITY raquo  "&#187;">
        <!ENTITY nbsp   "&#160;">
        <!ENTITY copy   "&#169;">
        <!ENTITY rarr   "&#8594;">
        <!ENTITY larr   "&#8592;">
        <!ENTITY hellip "&#8230;">
        <!ENTITY mdash  "&#8212;">
        <!ENTITY copy   "&#169;">
        <!ENTITY lf     "&#x0A;">
        ]>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:math="http://exslt.org/math"
                extension-element-prefixes="math"
                xmlns:i18n="urn:yandex-functions:internationalization"
                version="1.0">

    <xsl:import href="email-xslts/common-event.xsl" />
    <xsl:output method="html" indent="no"/>


    <xsl:template match="message">
        <message type="mixed">
            <xsl:call-template name="message-header">
                <xsl:with-param name="subject" select="$event-name"/>
            </xsl:call-template>

            <part id="1" type="alternative">
                <part id="1_1" content-type="text/plain; charset=utf-8">
                    <xsl:call-template name="text-part-plain-common"/>
                </part>
                <part id="1_2" content-type="text/html; charset=utf-8">
                    <xsl:call-template name="text-part-html-common"/>
                </part>
                <!-- to akirakozov: text/calendar is not alternative to text and html parts -->
                <!-- otherwise message looks like this: http://screencast.com/t/82OqFxPYiX  -->
                <!-- or this: http://screencast.com/t/ilk4iyvj -->
                <xsl:if test="ics">
                    <part id="1_3" content-type="text/calendar; charset=utf-8; method=REQUEST"><xsl:value-of select="ics" /></part>

                </xsl:if>
            </part> <!-- alternative -->
            <xsl:if test="ics">
                <part id="2" content-type="application/ics;charset=utf-8" name="event.ics"><xsl:value-of select="ics" /></part>
            </xsl:if>
        </message>
    </xsl:template>


    <!-- Plain part -->

    <xsl:template name="text-part-plain-custom">
        <xsl:text>&laquo;</xsl:text><xsl:value-of select="$event-name"/><xsl:text>&raquo;</xsl:text>
        <xsl:text>&lf;</xsl:text>
        <xsl:call-template name="event-edit-link-lf-plain"/>
        <xsl:call-template name="when-full"/>
        <xsl:apply-templates select="rep-hints" mode="plain"/>
        <xsl:text>&lf;&lf;</xsl:text>

        <xsl:if test="for-organizer-or-creator != '1' and for-sender != '1'">
            <xsl:call-template name="event-decision-actions-bar-plain"/>
        </xsl:if>

        <xsl:text>&lf;</xsl:text>
        <xsl:apply-templates select="event-location" mode="plain"/>
        <xsl:apply-templates select="event-description-text" mode="plain"/>
        <xsl:text>&lf;</xsl:text>

        <xsl:apply-templates select="organizer-nick" mode="plain"/>

        <xsl:apply-templates select="guests" mode="plain"/>
    </xsl:template>


    <!-- Html part -->

    <xsl:template name="text-part-html-custom">
        <table cellpadding="4" width="100%">
        <tr>
            <xsl:if test="for-organizer-or-creator != '1' and for-sender != '1'">
            <td>
                <font face="Arial,sans-serif" size="4">
                    <xsl:text>&laquo;</xsl:text><xsl:call-template name="event-and-edit-link-html"/><xsl:text>&raquo;</xsl:text>
                </font>
                <br/>
            </td>
            </xsl:if>
            <xsl:if test="for-organizer-or-creator = '1' or for-sender = '1'">
            <td>
                <xsl:if test="for-organizer-or-creator = '1'">
                    <xsl:attribute name="bgcolor">#e4f0df</xsl:attribute>
                </xsl:if>
                <xsl:if test="for-organizer-or-creator != '1' and for-sender = '1'">
                    <xsl:attribute name="bgcolor">#e3eafd</xsl:attribute>
                </xsl:if>
                <table cellspacing="0" cellpadding="5">
                    <tr>
                        <td style="padding: 0 7px 1px">
                            <font face="Arial,sans-serif" size="4">
                                <b>
                                    <xsl:call-template name="Event-created">
                                        <xsl:with-param name="event-name">
                                            <xsl:call-template name="event-and-edit-link-html"/>
                                        </xsl:with-param>
                                    </xsl:call-template>
                                </b>
                            </font>
                        </td>
                    </tr>
                </table>
            </td>
            </xsl:if>
        </tr>
        <tr>
            <td>
                <font face="Arial,sans-serif" size="3">
                    <xsl:call-template name="when-full"/>
                    <xsl:apply-templates select="rep-hints" mode="html"/>
                </font>
            </td>
        </tr>
        </table>

        <xsl:if test="for-organizer-or-creator != '1' and for-sender != '1'">
            <xsl:call-template name="event-decision-actions-bar-html"/>
        </xsl:if>

        <table cellpadding="4">

        <xsl:apply-templates select="event-location" mode="html"/>
        <xsl:apply-templates select="event-description-xml" mode="html"/>

        <xsl:apply-templates select="organizer-nick" mode="html"/>

        <xsl:apply-templates select="guests" mode="html"/>

        </table>
    </xsl:template>

    <!--  Common part -->

    <xsl:template name="Event-created">
        <xsl:param name="event-name"/>

        <xsl:choose>
            <xsl:when test="$is-meeting">
                <xsl:call-template name="i18n:calendar.emails2.Meeting">
                    <xsl:with-param name="event-name" select="$event-name"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="i18n:calendar.emails2.Event">
                    <xsl:with-param name="event-name" select="$event-name"/>
                </xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

</xsl:stylesheet>

<!-- vim: set encoding=utf-8 ts=4 sw=4 et: -->
