<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="urn:yandex-functions:internationalization"
                exclude-result-prefixes="i18n">

    <xsl:import href="email-xslts/common-event.xsl" />
    <xsl:output method="html" indent="no"/>

    <xsl:template name="subject-row">
        <xsl:param name="subject"/>
        <xsl:variable name="border-style">
            <xsl:if test="layer-color">border-bottom: 7px solid <xsl:value-of select="layer-color"/>;</xsl:if>
        </xsl:variable>
        <tr>
            <td style="padding: 7px 0 4px 4px; {$border-style}">
                <font face="Arial,sans-serif" size="4">
                    <b>
                        <xsl:copy-of select="$subject"/>
                    </b>
                </font>
            </td>
        </tr>
    </xsl:template>

</xsl:stylesheet>
