<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="urn:yandex-functions:internationalization"
                exclude-result-prefixes="i18n">

    <xsl:import href="email-xslts/event-layer-common.xsl"/>

    <xsl:template match="message">
        <message>
            <xsl:call-template name="message-header">
                <xsl:with-param name="subject">
                    <xsl:call-template name="i18n:calendar.emails2.Event-layer-removed_subject">
                        <xsl:with-param name="layer-name" select="layer-name"/>
                    </xsl:call-template>
                </xsl:with-param>
            </xsl:call-template>

            <part id="1" type="single" content-type="text/html; charset=utf-8">
                <xsl:call-template name="text-part-html-common"/>
            </part>
        </message>
    </xsl:template>

    <xsl:template name="text-part-html-custom">
        <table cellpadding="4" width="100%">
            <xsl:call-template name="subject-row">
                <xsl:with-param name="subject">
                    <xsl:if test="show-actor != '1'">
                        <xsl:call-template name="i18n:calendar.emails2.Event-layer-removed">
                            <xsl:with-param name="event-name" select="event-name/text()"/>
                            <xsl:with-param name="layer-name" select="layer-name/text()"/>
                        </xsl:call-template>
                    </xsl:if>
                    <xsl:if test="show-actor = '1' and sender-gender != 'F'">
                        <xsl:call-template name="i18n:calendar.emails2.Event-layer-removed-by-user">
                            <xsl:with-param name="user-name" select="sender-nick/text()"/>
                            <xsl:with-param name="event-name" select="event-name/text()"/>
                            <xsl:with-param name="layer-name" select="layer-name/text()"/>
                        </xsl:call-template>
                    </xsl:if>
                    <xsl:if test="show-actor = '1' and sender-gender = 'F'">
                        <xsl:call-template name="i18n:calendar.emails2.Event-layer-removed-by-user_female">
                            <xsl:with-param name="user-name" select="sender-nick/text()"/>
                            <xsl:with-param name="event-name" select="event-name/text()"/>
                            <xsl:with-param name="layer-name" select="layer-name/text()"/>
                        </xsl:call-template>
                    </xsl:if>
                </xsl:with-param>
            </xsl:call-template>
            <tr>
                <td colspan="3">
                    <font face="Arial,sans-serif" size="3">
                        <xsl:call-template name="capitalize">
                            <xsl:with-param name="str">
                                <xsl:call-template name="since-with-no-end-repetition"/>
                            </xsl:with-param>
                        </xsl:call-template>
                    </font>
                </td>
            </tr>
        </table>
    </xsl:template>

    <xsl:template name="text-part-plain-custom"/>

</xsl:stylesheet>
