<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet [
        <!ENTITY quot   "&#34;">
        <!ENTITY laquo  "&#171;">
        <!ENTITY raquo  "&#187;">
        <!ENTITY nbsp   "&#160;">
        <!ENTITY copy   "&#169;">
        <!ENTITY rarr   "&#8594;">
        <!ENTITY larr   "&#8592;">
        <!ENTITY hellip "&#8230;">
        <!ENTITY mdash  "&#8212;">
        <!ENTITY copy   "&#169;">
        <!ENTITY lf     "&#x0A;">
        ]>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:math="http://exslt.org/math"
                xmlns:date="http://exslt.org/dates-and-times"
                xmlns:func="http://exslt.org/functions"
                xmlns:exsl="http://exslt.org/common"
                extension-element-prefixes="exsl math date func"
                xmlns:i18n="urn:yandex-functions:internationalization"
                version="1.0">

    <xsl:import href="email-xslts/common-event.xsl" />
    <xsl:output method="html" indent="no"/>


    <xsl:template match="message">
        <message type="alternative">
            <xsl:call-template name="message-header">
                <xsl:with-param name="subject">
                    <xsl:if test="not(subject)">
                        <xsl:call-template name="when-full"/>
                        <xsl:if test="$language = 'ru'">
                            <xsl:text>, </xsl:text>
                        </xsl:if>
                        <xsl:if test="$language != 'ru'">
                            <xsl:text> </xsl:text>
                        </xsl:if>
                        <xsl:value-of select="$q-event-name"/>
                    </xsl:if>
                    <xsl:if test="subject">
                        <xsl:value-of select="subject"/>
                    </xsl:if>
                </xsl:with-param>
            </xsl:call-template>

            <part id="1" content-type="text/plain; charset=utf-8">
                <xsl:call-template name="text-part-plain-common"/>
            </part>
            <part id="2" content-type="text/html; charset=utf-8">
                <xsl:call-template name="text-part-html-common"/>
            </part>
        </message>
    </xsl:template>


    <xsl:variable name="out-location-resources-phones" select="true()"/>

    <!-- Plain part -->

    <xsl:template name="text-part-plain-custom">
        <xsl:call-template name="Event-reminder">
            <xsl:with-param name="event-name" select="$event-name"/>
            <xsl:with-param name="when">
                <xsl:call-template name="when-full-lower"/>
            </xsl:with-param>
        </xsl:call-template>
        <xsl:text>&lf;</xsl:text>
        <xsl:call-template name="event-edit-link-lf-plain"/>
        <xsl:text>&lf;</xsl:text>

        <xsl:apply-templates select="event-location" mode="plain"/>
        <xsl:apply-templates select="event-description-text" mode="plain"/>
    </xsl:template>


    <!-- Html part -->

    <xsl:template name="text-part-html-custom">
        <table cellpadding="4" width="100%">
        <tr>
            <td>
                <font size="4" face="Arial,sans-serif">
                    <b>
                        <xsl:call-template name="Event-reminder">
                            <xsl:with-param name="event-name">
                                <xsl:call-template name="event-and-edit-link-html"/>
                            </xsl:with-param>
                            <xsl:with-param name="when">
                                <xsl:call-template name="when-full-lower"/>
                            </xsl:with-param>
                        </xsl:call-template>
                    </b>
                </font>
            </td>
        </tr>
        </table>

        <table cellpadding="4">
        <xsl:apply-templates select="event-location" mode="html"/>
        <xsl:apply-templates select="event-description-xml" mode="html"/>
        </table>
    </xsl:template>


    <!--  Common part -->

    <!-- redefinition to make event link work -->
    <xsl:variable name="is-decision-yes" select="true()"/>

    <xsl:template name="Event-reminder">
        <xsl:param name="event-name"/>
        <xsl:param name="when"/>

        <xsl:choose>
            <xsl:when test="$is-meeting">
                <xsl:call-template name="i18n:calendar.emails2.Meeting-reminder">
                    <xsl:with-param name="event-name" select="$event-name"/>
                    <xsl:with-param name="when" select="$when"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="i18n:calendar.emails2.Event-reminder">
                    <xsl:with-param name="event-name" select="$event-name"/>
                    <xsl:with-param name="when" select="$when"/>
                </xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

</xsl:stylesheet>

<!-- vim: set encoding=utf-8 ts=4 sw=4 et: -->
