<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet [
        <!ENTITY quot   "&#34;">
        <!ENTITY laquo  "&#171;">
        <!ENTITY raquo  "&#187;">
        <!ENTITY nbsp   "&#160;">
        <!ENTITY copy   "&#169;">
        <!ENTITY rarr   "&#8594;">
        <!ENTITY larr   "&#8592;">
        <!ENTITY hellip "&#8230;">
        <!ENTITY mdash  "&#8212;">
        <!ENTITY copy   "&#169;">
        <!ENTITY lf     "&#x0A;">
        ]>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:math="http://exslt.org/math"
                extension-element-prefixes="math"
                xmlns:i18n="urn:yandex-functions:internationalization"
                version="1.0">

    <xsl:import href="email-xslts/common-event.xsl"/>
    <xsl:output method="html" indent="no"/>

    <xsl:template match="message">
        <message type="mixed">
            <xsl:call-template name="message-header">
                <xsl:with-param name="subject" select="event-name"/>
            </xsl:call-template>

            <part id="1" type="alternative">
                <part id="1_1" content-type="text/plain; charset=utf-8">
                    <xsl:value-of select="event-description-text"/>
                </part>
                <part id="1_2" content-type="text/html; charset=utf-8">
                    <xsl:apply-templates select="event-description-xml"/>
                </part>
                <xsl:if test="ics">
                    <part id="1_3" content-type="text/calendar; charset=utf-8; method=REQUEST">
                        <xsl:value-of select="ics"/>
                    </part>
                </xsl:if>
            </part>
        </message>
    </xsl:template>

    <xsl:template match="event-description-xml">
        <xsl:apply-templates mode="html"/>
    </xsl:template>

    <xsl:template name="text-part-plain-custom"/>
    <xsl:template name="text-part-html-custom"/>

</xsl:stylesheet>
