<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet [
        <!ENTITY quot   "&#34;">
        <!ENTITY laquo  "&#171;">
        <!ENTITY raquo  "&#187;">
        <!ENTITY nbsp   "&#160;">
        <!ENTITY copy   "&#169;">
        <!ENTITY rarr   "&#8594;">
        <!ENTITY larr   "&#8592;">
        <!ENTITY hellip "&#8230;">
        <!ENTITY mdash  "&#8212;">
        <!ENTITY copy   "&#169;">
        <!ENTITY lf     "&#x0A;">
        ]>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:math="http://exslt.org/math"
                extension-element-prefixes="math"
                xmlns:i18n="urn:yandex-functions:internationalization"
                version="1.0">

    <xsl:import href="email-xslts/common-event.xsl" />
    <xsl:output method="html" indent="no"/>

    <xsl:variable name="reason">
        <xsl:if test="/message/reason">
            <xsl:value-of select="/message/reason"/>
        </xsl:if>
        <xsl:if test="/message/special-reason = 'resource-uncheckin'">
            <xsl:call-template name="i18n:calendar.emails2.Comment-resource-uncheckin"/>
        </xsl:if>
        <xsl:if test="/message/special-reason = 'resource-total-uncheckin'">
            <xsl:call-template name="i18n:calendar.emails2.Comment-resource-total-uncheckin"/>
        </xsl:if>
    </xsl:variable>

    <xsl:template match="decision" mode="subject">
        <xsl:call-template name="i18n:calendar.emails2.subject_accepted">
            <xsl:with-param name="event-name" select="$event-name"/>
        </xsl:call-template>
    </xsl:template>
    <xsl:template match="decision[. = 'no']" mode="subject">
        <xsl:call-template name="i18n:calendar.emails2.subject_declined">
            <xsl:with-param name="event-name" select="$event-name"/>
        </xsl:call-template>
    </xsl:template>
    <xsl:template match="decision[. = 'maybe']" mode="subject">
        <xsl:call-template name="i18n:calendar.emails2.subject_tentative">
            <xsl:with-param name="event-name" select="$event-name"/>
        </xsl:call-template>
    </xsl:template>

    <xsl:template match="message">
        <message type="mixed">
            <xsl:call-template name="message-header">
                <xsl:with-param name="subject">
                    <xsl:apply-templates select="decision" mode="subject"/>
                </xsl:with-param>
            </xsl:call-template>

            <part id="1" type="alternative">
                <part id="1_1" content-type="text/plain; charset=utf-8">
                    <xsl:value-of select="$reason"/>
                </part>
                <part id="1_2" content-type="text/html; charset=utf-8">
                    <xsl:value-of select="$reason"/>
                </part>
                <xsl:if test="ics">
                    <part id="1_3" content-type="text/calendar; method=REPLY; charset=utf-8"><xsl:value-of select="ics" /></part>
                </xsl:if>
            </part>
        </message>
    </xsl:template>

    <xsl:template name="text-part-plain-custom"/>
    <xsl:template name="text-part-html-custom"/>

</xsl:stylesheet>
