<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet [
        <!ENTITY quot   "&#34;">
        <!ENTITY laquo  "&#171;">
        <!ENTITY raquo  "&#187;">
        <!ENTITY nbsp   "&#160;">
        <!ENTITY copy   "&#169;">
        <!ENTITY rarr   "&#8594;">
        <!ENTITY larr   "&#8592;">
        <!ENTITY hellip "&#8230;">
        <!ENTITY mdash  "&#8212;">
        <!ENTITY copy   "&#169;">
        <!ENTITY lf     "&#x0A;">
        ]>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:math="http://exslt.org/math"
                extension-element-prefixes="math"
                xmlns:i18n="urn:yandex-functions:internationalization"
                version="1.0">

    <xsl:import href="email-xslts/common-event.xsl" />
    <xsl:output method="html" indent="no"/>


    <xsl:template match="message">
        <message type="mixed">
            <xsl:call-template name="message-header">
                <xsl:with-param name="subject">
                    <xsl:call-template name="i18n:calendar.emails2.Decision-at-meeting-made">
                        <xsl:with-param name="name" select="sender-nick"/>
                        <xsl:with-param name="made-decision">
                            <xsl:apply-templates select="decision" mode="text"/>
                        </xsl:with-param>
                        <xsl:with-param name="event-name" select="$event-name"/>
                    </xsl:call-template>
                </xsl:with-param>
            </xsl:call-template>

            <part id="1" type="alternative">
                <part id="1_1" content-type="text/plain; charset=utf-8">
                    <xsl:call-template name="text-part-plain-common"/>
                </part>
                <part id="1_2" content-type="text/html; charset=utf-8">
                    <xsl:call-template name="text-part-html-common"/>
                </part>
                <xsl:if test="ics">
                    <part id="1_3" content-type="text/calendar; method=REPLY; charset=utf-8"><xsl:value-of select="ics" /></part>
                </xsl:if>
            </part>
            <xsl:if test="ics">
                <part id="2" content-type="application/ics;charset=utf-8" name="event.ics"><xsl:value-of select="ics" /></part>
            </xsl:if>
        </message>
    </xsl:template>

    <xsl:variable name="reason">
        <xsl:if test="/message/reason">
            <xsl:value-of select="/message/reason"/>
        </xsl:if>
        <xsl:if test="/message/special-reason = 'resource-uncheckin'">
            <xsl:call-template name="i18n:calendar.emails2.Comment-resource-uncheckin">
                <xsl:with-param name="minutes" select="/message/minutes-waited"/>
            </xsl:call-template>
        </xsl:if>
        <xsl:if test="/message/special-reason = 'resource-total-uncheckin'">
            <xsl:call-template name="i18n:calendar.emails2.Comment-resource-total-uncheckin">
                <xsl:with-param name="times" select="/message/times-in-a-row"/>
            </xsl:call-template>
        </xsl:if>
    </xsl:variable>

    <!-- Plain part -->

    <xsl:template name="text-part-plain-custom">
        <xsl:call-template name="i18n:calendar.emails2.Decision-at-meeting-made">
            <xsl:with-param name="name">
                <xsl:apply-templates select="sender-nick" mode="plain"/>
            </xsl:with-param>
            <xsl:with-param name="made-decision">
                <xsl:apply-templates select="decision" mode="text"/>
            </xsl:with-param>
            <xsl:with-param name="event-name" select="$event-name"/>
        </xsl:call-template>
        <xsl:text>&lf;</xsl:text>
        <xsl:call-template name="event-edit-link-lf-plain"/>

        <xsl:text>&lf;</xsl:text>
        <xsl:apply-templates select="event-location" mode="plain"/>
        <xsl:call-template name="i18n:calendar.emails2.Time"/>
        <xsl:text>:&nbsp;</xsl:text>
        <xsl:call-template name="since-with-repetition"/>
        <xsl:text>&lf;</xsl:text>

        <xsl:if test="$reason != ''"><xsl:call-template name="reason-plain"/></xsl:if>
    </xsl:template>


    <!-- Html part -->

    <xsl:template name="text-part-html-custom">
        <table cellpadding="4" width="100%">
        <tr>
            <td>
                <xsl:attribute name="bgcolor">
                    <xsl:apply-templates select="decision" mode="color"/>
                </xsl:attribute>
                <table cellspacing="0" cellpadding="5">
                <tr>
                    <td style="padding: 0 7px 1px">
                        <font size="4" face="Arial,sans-serif">
                            <b>
                                <xsl:call-template name="i18n:calendar.emails2.Decision-at-meeting-made">
                                    <xsl:with-param name="name">
                                        <xsl:apply-templates select="sender-nick" mode="html"/>
                                    </xsl:with-param>
                                    <xsl:with-param name="made-decision">
                                        <xsl:apply-templates select="decision" mode="text"/>
                                    </xsl:with-param>
                                    <xsl:with-param name="event-name">
                                        <xsl:call-template name="event-and-edit-link-html"/>
                                    </xsl:with-param>
                                </xsl:call-template>
                            </b>
                        </font>
                    </td>
                </tr>
                </table>
            </td>
        </tr>
        </table>

        <table cellpadding="4">
        <xsl:apply-templates select="event-location" mode="html"/>
        <tr>
            <td valign="top">
                <font color="#a2a2a2" face="Arial,sans-serif" size="3">
                    <b><xsl:call-template name="i18n:calendar.emails2.Time"/></b>
                </font>
            </td>
            <td width="5"/>
            <td>
                <font face="Arial,sans-serif" size="3">
                    <xsl:call-template name="since-with-repetition"/>
                </font>
            </td>
        </tr>

        <xsl:if test="$reason != ''"><xsl:call-template name="reason-html"/></xsl:if>
        </table>
    </xsl:template>

    <xsl:template name="reason-html">
        <tr>
            <td valign="top">
                <font color="#a2a2a2" face="Arial,sans-serif" size="3">
                    <b><xsl:call-template name="i18n:calendar.emails2.Comment"/></b>
                </font>
            </td>
            <td width="5"/>
            <td>
                <font face="Arial,sans-serif" size="3">
                    <xsl:value-of select="$reason"/>
                </font>
            </td>
        </tr>
    </xsl:template>

    <xsl:template name="reason-plain">
        <xsl:call-template name="i18n:calendar.emails2.Comment"/>
        <xsl:text>:&nbsp;</xsl:text>
        <xsl:value-of select="$reason"/>
        <xsl:text>&lf;</xsl:text>
    </xsl:template>

    <!--  Common part -->

    <xsl:template match="decision" mode="text">
        <xsl:call-template name="i18n:calendar.emails2.accepted"/>
    </xsl:template>
    <xsl:template match="decision[. = 'no']" mode="text">
        <xsl:call-template name="i18n:calendar.emails2.rejected"/>
    </xsl:template>
    <xsl:template match="decision[. = 'maybe']" mode="text">
        <xsl:call-template name="i18n:calendar.emails2.tentatively-accepted"/>
    </xsl:template>

    <xsl:template match="decision[//sender-gender = 'F']" mode="text">
        <xsl:call-template name="i18n:calendar.emails2.accepted_female"/>
    </xsl:template>
    <xsl:template match="decision[. = 'no' and //sender-gender = 'F']" mode="text">
        <xsl:call-template name="i18n:calendar.emails2.rejected_female"/>
    </xsl:template>
    <xsl:template match="decision[. = 'maybe' and //sender-gender = 'F']" mode="text">
        <xsl:call-template name="i18n:calendar.emails2.tentatively-accepted_female"/>
    </xsl:template>

    <xsl:template match="decision" mode="color">
        <xsl:text>e4f0df</xsl:text>
    </xsl:template>
    <xsl:template match="decision[. = 'no']" mode="color">
        <xsl:text>f6e9e4</xsl:text>
    </xsl:template>

</xsl:stylesheet>

<!-- vim: set encoding=utf-8 ts=4 sw=4 et: -->
