<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="urn:yandex-functions:internationalization"
                exclude-result-prefixes="i18n">

    <xsl:import href="email-xslts/common-event.xsl"/>

    <xsl:template match="message">
        <message>
            <xsl:call-template name="message-header">
                <xsl:with-param name="subject">
                    <xsl:call-template name="i18n:calendar.emails2.Event-resource-added_subject">
                        <xsl:with-param name="resource-name" select="resource-name"/>
                    </xsl:call-template>
                </xsl:with-param>
            </xsl:call-template>

            <part id="1" type="single" content-type="text/html; charset=utf-8">
                <xsl:call-template name="text-part-html-common"/>
            </part>
        </message>
    </xsl:template>

    <xsl:template name="subject-row">
        <xsl:param name="subject"/>
        <tr>
            <td style="padding: 7px 0 4px 4px; border-bottom: 7px solid #e4f0df;">
                <font face="Arial,sans-serif" size="4">
                    <b>
                        <xsl:copy-of select="$subject"/>
                    </b>
                </font>
            </td>
        </tr>
    </xsl:template>

    <xsl:variable name="event-name-with-link">
        <a href="{$event-edit-link}"><xsl:value-of select="$event-name"/></a>
    </xsl:variable>

    <xsl:template name="text-part-html-custom">
        <table cellpadding="4" width="100%">
            <xsl:call-template name="subject-row">
                <xsl:with-param name="subject">
                    <xsl:if test="sender-gender != 'F'">
                        <xsl:call-template name="i18n:calendar.emails2.Event-resource-added-by-user">
                            <xsl:with-param name="user-name" select="sender-nick/text()"/>
                            <xsl:with-param name="event-name" select="$event-name-with-link"/>
                            <xsl:with-param name="resource-name" select="resource-name/text()"/>
                        </xsl:call-template>
                    </xsl:if>
                    <xsl:if test="sender-gender = 'F'">
                        <xsl:call-template name="i18n:calendar.emails2.Event-resource-added-by-user_female">
                            <xsl:with-param name="user-name" select="sender-nick/text()"/>
                            <xsl:with-param name="event-name" select="$event-name-with-link"/>
                            <xsl:with-param name="resource-name" select="resource-name/text()"/>
                        </xsl:call-template>
                    </xsl:if>
                </xsl:with-param>
            </xsl:call-template>
            <tr>
                <td colspan="3">
                    <font face="Arial,sans-serif" size="3">
                        <xsl:call-template name="when-full"/>
                        <xsl:apply-templates select="rep-hints" mode="html"/>
                    </font>
                </td>
            </tr>
        </table>
        <table cellpadding="4">
            <xsl:apply-templates select="event-location" mode="html"/>
            <xsl:apply-templates select="event-description-xml" mode="html"/>
            <xsl:apply-templates select="organizer-nick" mode="html"/>
            <xsl:apply-templates select="guests" mode="html"/>
        </table>
    </xsl:template>

    <xsl:template name="text-part-plain-custom"/>

</xsl:stylesheet>
