<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet [
        <!ENTITY quot   "&#34;">
        <!ENTITY laquo  "&#171;">
        <!ENTITY raquo  "&#187;">
        <!ENTITY nbsp   "&#160;">
        <!ENTITY copy   "&#169;">
        <!ENTITY rarr   "&#8594;">
        <!ENTITY larr   "&#8592;">
        <!ENTITY hellip "&#8230;">
        <!ENTITY mdash  "&#8212;">
        <!ENTITY copy   "&#169;">
        <!ENTITY lf     "&#x0A;">
        ]>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:math="http://exslt.org/math"
                extension-element-prefixes="math"
                xmlns:i18n="urn:yandex-functions:internationalization"
                version="1.0">

    <xsl:import href="email-xslts/common-event.xsl" />
    <xsl:output method="html" indent="no"/>


    <xsl:template match="message">
        <message type="mixed">
            <xsl:call-template name="message-header">
                <xsl:with-param name="subject" select="event-name"/>
            </xsl:call-template>

            <part id="1" type="alternative">
                <xsl:if test="info-for-ya-mail">
                    <!-- CAL-7323 -->
                    <part id="1_0" content-type="text/json; charset=utf-8"><xsl:value-of select="info-for-ya-mail" /></part>
                </xsl:if>
                <part id="1_1" content-type="text/plain; charset=utf-8">
                    <xsl:call-template name="text-part-plain-common"/>
                </part>
                <part id="1_2" content-type="text/html; charset=utf-8">
                    <xsl:call-template name="text-part-html-common"/>
                </part>
                <xsl:if test="ics">
                    <part id="1_3" content-type="text/calendar; charset=utf-8; method=REQUEST"><xsl:value-of select="ics" /></part>
                </xsl:if>
            </part> <!-- alternative -->
            <xsl:if test="ics">
                <part id="2" content-type="application/ics;charset=utf-8" name="event.ics"><xsl:value-of select="ics" /></part>
            </xsl:if>
        </message>
    </xsl:template>


    <!-- Plain part -->

    <xsl:template name="text-part-plain-custom">
        <xsl:call-template name="User-changed-event">
            <xsl:with-param name="sender-name">
                <xsl:apply-templates select="sender-nick" mode="plain"/>
            </xsl:with-param>
            <xsl:with-param name="event-name" select="$event-name"/>
        </xsl:call-template>
        <xsl:text>&lf;</xsl:text>
        <xsl:call-template name="event-edit-link-lf-plain"/>
        <xsl:text>&lf;</xsl:text>

        <xsl:apply-templates select="event-location" mode="plain"/>

        <xsl:if test="event-changes/when = 1">
            <xsl:call-template name="i18n:calendar.emails2.Becomes"/>:&nbsp;
        </xsl:if>
        <xsl:call-template name="when-full">
            <xsl:with-param name="upper" select="event-changes/when != '1'"/>
        </xsl:call-template>
        <xsl:apply-templates select="rep-hints" mode="plain"/>
        <xsl:text>&lf;&lf;</xsl:text>

        <xsl:apply-templates select="event-description-text" mode="plain"/>
        <xsl:text>&lf;</xsl:text>

        <xsl:apply-templates select="organizer-nick" mode="plain"/>

        <xsl:apply-templates select="guests" mode="plain"/>
        <xsl:text>&lf;</xsl:text>

        <xsl:if test="for-organizer-or-creator != '1' or not($is-decision-yes) and for-sender != '1'">
            <xsl:call-template name="event-decision-actions-bar-plain"/>
        </xsl:if>
    </xsl:template>


    <!-- Html part -->

    <xsl:template name="text-part-html-custom">
        <table cellpadding="4" width="100%">
        <tr>
            <td>
                <xsl:if test="for-organizer-or-creator = '1' and $is-decision-yes">
                    <xsl:attribute name="bgcolor">#e4f0df</xsl:attribute>
                </xsl:if>
                <xsl:if test="for-organizer-or-creator != '1' and for-sender = '1'">
                    <xsl:attribute name="bgcolor">#e3eafd</xsl:attribute>
                </xsl:if>
                <table cellspacing="0" cellpadding="5">
                    <tr>
                        <td style="padding: 0 7px 1px">
                            <font size="4" face="Arial,sans-serif">
                                <b>
                                    <xsl:call-template name="User-changed-event">
                                        <xsl:with-param name="sender-name">
                                            <xsl:apply-templates select="sender-nick" mode="html"/>
                                        </xsl:with-param>
                                        <xsl:with-param name="event-name">
                                            <xsl:call-template name="event-and-edit-link-html"/>
                                        </xsl:with-param>
                                    </xsl:call-template>
                                </b>
                            </font>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
        <tr>
            <td>
                <xsl:if test="event-changes/when = 1">
                    <font color="#349900" face="Arial,sans-serif" size="3">
                        <xsl:call-template name="i18n:calendar.emails2.Becomes"/>:&nbsp;
                    </font>
                </xsl:if>
                <font face="Arial,sans-serif" size="3">
                    <xsl:call-template name="when-full">
                        <xsl:with-param name="upper" select="event-changes/when != '1'"/>
                    </xsl:call-template>
                    <xsl:apply-templates select="rep-hints" mode="html"/>
                </font>
            </td>
        </tr>
        </table>

        <table cellpadding="4">

        <xsl:apply-templates select="event-location" mode="html"/>

        <xsl:apply-templates select="event-description-xml" mode="html"/>

        <xsl:apply-templates select="organizer-nick" mode="html"/>

        <xsl:if test="guests-changes">
            <xsl:apply-templates select="guests-changes" mode="html"/>
        </xsl:if>
        <xsl:if test="not(guests-changes)">
            <xsl:apply-templates select="guests" mode="html"/>
        </xsl:if>

        </table>

        <xsl:if test="for-organizer-or-creator != '1' or not($is-decision-yes) and for-sender != '1'">
            <xsl:call-template name="event-decision-actions-bar-html"/>
        </xsl:if>
    </xsl:template>


    <!--  Common part -->

    <xsl:template name="User-changed-event">
        <xsl:param name="sender-name"/>
        <xsl:param name="event-name"/>

        <xsl:variable name="hide-actor" select="//for-sender = '1' or //hide-actor = '1'"/>
        <xsl:variable name="female-sender" select="//sender-gender = 'F'"/>

        <xsl:if test="$hide-actor and $is-meeting">
            <xsl:call-template name="i18n:calendar.emails2.Meeting-changed">
                <xsl:with-param name="event-name" select="$event-name"/>
            </xsl:call-template>
        </xsl:if>
        <xsl:if test="$hide-actor and not($is-meeting)">
            <xsl:call-template name="i18n:calendar.emails2.Event-changed">
                <xsl:with-param name="event-name" select="$event-name"/>
            </xsl:call-template>
        </xsl:if>
        <xsl:if test="not($hide-actor) and $is-meeting and not($female-sender)">
            <xsl:call-template name="i18n:calendar.emails2.User-changed-meeting">
                <xsl:with-param name="user-name" select="$sender-name"/>
                <xsl:with-param name="event-name" select="$event-name"/>
            </xsl:call-template>
        </xsl:if>
        <xsl:if test="not($hide-actor) and not($is-meeting) and not($female-sender)">
            <xsl:call-template name="i18n:calendar.emails2.User-changed-event">
                <xsl:with-param name="user-name" select="$sender-name"/>
                <xsl:with-param name="event-name" select="$event-name"/>
            </xsl:call-template>
        </xsl:if>
        <xsl:if test="not($hide-actor) and $is-meeting and $female-sender">
            <xsl:call-template name="i18n:calendar.emails2.User-changed-meeting_female">
                <xsl:with-param name="user-name" select="$sender-name"/>
                <xsl:with-param name="event-name" select="$event-name"/>
            </xsl:call-template>
        </xsl:if>
        <xsl:if test="not($hide-actor) and not($is-meeting) and $female-sender">
            <xsl:call-template name="i18n:calendar.emails2.User-changed-event_female">
                <xsl:with-param name="user-name" select="$sender-name"/>
                <xsl:with-param name="event-name" select="$event-name"/>
            </xsl:call-template>
        </xsl:if>

    </xsl:template>

</xsl:stylesheet>

<!-- vim: set encoding=utf-8 ts=4 sw=4 et: -->
