<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet [
        <!ENTITY quot   "&#34;">
        <!ENTITY laquo  "&#171;">
        <!ENTITY raquo  "&#187;">
        <!ENTITY nbsp   "&#160;">
        <!ENTITY copy   "&#169;">
        <!ENTITY rarr   "&#8594;">
        <!ENTITY larr   "&#8592;">
        <!ENTITY hellip "&#8230;">
        <!ENTITY mdash  "&#8212;">
        <!ENTITY copy   "&#169;">
        <!ENTITY lf     "&#x0A;">
        ]>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:math="http://exslt.org/math"
                xmlns:str="http://exslt.org/strings"
                extension-element-prefixes="math str"
                xmlns:i18n="urn:yandex-functions:internationalization"
                version="1.0">

    <xsl:import href="email-xslts/common-event.xsl" />
    <xsl:output method="html" indent="no"/>


    <xsl:template match="message">
        <message type="alternative">
            <xsl:call-template name="message-header">
                <xsl:with-param name="subject">
                    <xsl:call-template name="i18n:calendar.emails2.You-are-given-access-to-calendar"/>
                </xsl:with-param>
            </xsl:call-template>

            <part id="1" content-type="text/plain; charset=utf-8">
                <xsl:call-template name="text-part-plain-common"/>
            </part>
            <part id="2" content-type="text/html; charset=utf-8">
                <xsl:call-template name="text-part-html-common"/>
            </part>
        </message>
    </xsl:template>


    <!-- Plain part -->

    <xsl:template name="text-part-plain-custom">
        <xsl:call-template name="i18n:calendar.emails2.Now-you-can-use-layer">
            <xsl:with-param name="layer-name"><xsl:value-of select="layer-name"/></xsl:with-param>
        </xsl:call-template>
        <xsl:text>&lf;</xsl:text>
        <xsl:call-template name="layer-go-calendar-link-lf-plain"/>
        <xsl:text>&lf;</xsl:text>

        <xsl:call-template name="layer-decision-actions-bar-plain"/>
    </xsl:template>

    <xsl:template name="layer-go-calendar-link-lf-plain">
        <xsl:if test="auto">
            <xsl:value-of select="$go-calendar-link"/>
            <xsl:text>&lf;</xsl:text>
        </xsl:if>
    </xsl:template>

    <xsl:template name="layer-decision-actions-bar-plain">
        <xsl:if test="not(auto)">
            <xsl:call-template name="decision-action-plain">
                <xsl:with-param name="link" select="$layer-accept-link"/>
                <xsl:with-param name="text"><xsl:call-template name="i18n:calendar.emails2.Accept"/></xsl:with-param>
            </xsl:call-template>
        </xsl:if>
        <xsl:if test="true()">
            <xsl:call-template name="decision-action-plain">
                <xsl:with-param name="link" select="$layer-decline-link"/>
                <xsl:with-param name="text"><xsl:call-template name="i18n:calendar.emails2.Decline"/></xsl:with-param>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>


    <!-- Html part -->

    <xsl:template name="text-part-html-custom">
        <table cellpadding="4" width="100%">
        <tr>
            <td>
                <font size="4" face="Arial,sans-serif">
                    <b>
                        <xsl:call-template name="i18n:calendar.emails2.Now-you-can-use-layer">
                            <xsl:with-param name="layer-name">
                                <xsl:call-template name="layer-and-go-calendar-link-html"/>
                            </xsl:with-param>
                        </xsl:call-template>
                    </b>
                </font>
            </td>
        </tr>
        </table>

        <xsl:call-template name="layer-decision-actions-bar-html"/>
    </xsl:template>

    <xsl:template name="layer-and-go-calendar-link-html">
        <xsl:choose>
            <xsl:when test="auto">
                <a href="{$go-calendar-link}"><xsl:value-of select="layer-name"/></a>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="layer-name"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="layer-decision-actions-bar-html">
        <table cellpadding="4" width="100%">
        <tr>
            <td bgcolor="#e3eafd">
                <table cellspacing="0" cellpadding="5">
                <tr>
                    <xsl:if test="not(auto)">
                        <xsl:call-template name="decision-action-html">
                            <xsl:with-param name="link" select="$layer-accept-link"/>
                            <xsl:with-param name="text"><xsl:call-template name="i18n:calendar.emails2.Accept"/></xsl:with-param>
                        </xsl:call-template>
                    </xsl:if>
                    <xsl:if test="true()">
                        <xsl:call-template name="decision-action-html">
                            <xsl:with-param name="link" select="$layer-decline-link"/>
                            <xsl:with-param name="text"><xsl:call-template name="i18n:calendar.emails2.Decline"/></xsl:with-param>
                        </xsl:call-template>
                    </xsl:if>
                </tr>
                </table>
            </td>
        </tr>
        </table>
    </xsl:template>

    <!-- Common part -->

    <!-- ssytnik: this dirty hack (variable redefinition) makes go-calendar-* templates work.
         This is needed because layer message parameters doesn't contain event start-ts -->
    <xsl:variable name="start-ts"><xsl:value-of select="current-dateTime()"/></xsl:variable>

    <xsl:variable name="layer-accept-link">
        <xsl:value-of select="$calendar-url"/>
        <xsl:text><![CDATA[/api/handle-layer-invitation]]></xsl:text>
        <xsl:value-of select="$query-uid-param"/>
        <xsl:text><![CDATA[private_token=]]></xsl:text><xsl:value-of select="$ptk"/>
        <xsl:text><![CDATA[&decision=yes]]></xsl:text>
        <xsl:text><![CDATA[&layer_name=]]></xsl:text><xsl:value-of select="encode-for-uri(message/layer-name)"/>
    </xsl:variable>

    <xsl:variable name="layer-decline-link">
        <xsl:value-of select="$calendar-url"/>
        <xsl:text><![CDATA[/api/handle-layer-invitation]]></xsl:text>
        <xsl:value-of select="$query-uid-param"/>
        <xsl:text><![CDATA[private_token=]]></xsl:text><xsl:value-of select="$ptk"/>
        <xsl:text><![CDATA[&decision=no]]></xsl:text>
    </xsl:variable>

</xsl:stylesheet>

<!-- vim: set encoding=utf-8 ts=4 sw=4 et: -->
