<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet [
        <!ENTITY quot   "&#34;">
        <!ENTITY laquo  "&#171;">
        <!ENTITY raquo  "&#187;">
        <!ENTITY nbsp   "&#160;">
        <!ENTITY copy   "&#169;">
        <!ENTITY rarr   "&#8594;">
        <!ENTITY larr   "&#8592;">
        <!ENTITY hellip "&#8230;">
        <!ENTITY mdash  "&#8212;">
        <!ENTITY copy   "&#169;">
        <!ENTITY lf     "&#x0A;">
        ]>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="urn:yandex-functions:internationalization"
                version="1.0">

    <xsl:import href="email-xslts/common-event.xsl" />
    <xsl:output method="html" indent="no"/>

    <xsl:variable name="event-name" select="message/event-name"/>
    <xsl:variable name="room-name" select="message/room-name"/>
    <xsl:variable name="repetition-description" select="message/repetition-description"/>

    <xsl:variable name="deadline">
        <xsl:call-template name="Date">
            <xsl:with-param name="day-number" select="format-dateTime(message/deadline, '[D1]', 'en', 'AD', '')"/>
            <xsl:with-param name="month-number" select="format-dateTime(message/deadline, '[M1]', 'en', 'AD', '')"/>
        </xsl:call-template>
    </xsl:variable>

    <xsl:variable name="subject">
        <xsl:call-template name="i18n:calendar.emails2.repetition-confirmation_subject">
            <xsl:with-param name="event-name" select="$event-name"/>
        </xsl:call-template>
    </xsl:variable>

    <xsl:variable name="message-head">
        <xsl:call-template name="i18n:calendar.emails2.repetiion-confirmation_message-head">
            <xsl:with-param name="event-name" select="$event-name"/>
            <xsl:with-param name="room-name" select="$room-name"/>
            <xsl:with-param name="repetition-description" select="$repetition-description"/>
            <xsl:with-param name="deadline" select="$deadline"/>
        </xsl:call-template>
    </xsl:variable>

    <xsl:template match="message">
        <message type="alternative">
            <xsl:call-template name="message-header">
                <xsl:with-param name="subject" select="$subject"/>
            </xsl:call-template>

            <part id="1" content-type="text/plain; charset=utf-8">
                <xsl:call-template name="text-part-plain-local"/>
            </part>
            <part id="2" content-type="text/html; charset=utf-8">
                <xsl:call-template name="text-part-html-local"/>
            </part>
        </message>
    </xsl:template>

    <!-- Plain part -->

    <xsl:template name="text-part-plain-custom"/>

    <xsl:template name="text-part-plain-local">
        <xsl:value-of select="$message-head"/>
        <xsl:text>&lf;&lf;</xsl:text>
        <xsl:value-of select="$event-page-link"/>
        <xsl:text>&lf;&lf;--&lf;</xsl:text>
        <xsl:call-template name="i18n:calendar.emails2.Your-calendar"/>
    </xsl:template>

    <!-- Html part -->

    <xsl:template name="text-part-html-custom"/>

    <xsl:template name="text-part-html-local">
        <html>
            <head>
                <meta http-equiv="Content-type" content="text/html; charset=utf-8" />
            </head>
            <body>
                <p><xsl:value-of select="replace($message-head, '\n', '&lt;br/&gt;')" disable-output-escaping="yes"/></p>
                <p><a href="{$event-page-link}"><xsl:value-of select="$event-page-link"/></a></p>
                <p><xsl:text>--</xsl:text><br/><xsl:call-template name="i18n:calendar.emails2.Your-calendar"/></p>
            </body>
        </html>
    </xsl:template>

</xsl:stylesheet>
