<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet [
        <!ENTITY quot   "&#34;">
        <!ENTITY laquo  "&#171;">
        <!ENTITY raquo  "&#187;">
        <!ENTITY nbsp   "&#160;">
        <!ENTITY copy   "&#169;">
        <!ENTITY rarr   "&#8594;">
        <!ENTITY larr   "&#8592;">
        <!ENTITY hellip "&#8230;">
        <!ENTITY mdash  "&#8212;">
        <!ENTITY copy   "&#169;">
        <!ENTITY lf     "&#x0A;">
        <!ENTITY bullet "&#8226;">
        ]>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:math="http://exslt.org/math"
                extension-element-prefixes="math"
                xmlns:i18n="urn:yandex-functions:internationalization"
                version="1.0">

    <xsl:import href="i18n/@LANGUAGE@/calendar.todo-email.xsl"/>
    <xsl:import href="email-xslts/common-message.xsl" />
    <xsl:output method="html" indent="no"/>

    <xsl:variable name="todo-list-name">
        <xsl:value-of select="message/todo-list-name"/>
    </xsl:variable>

    <xsl:variable name="todo-service-link">
        <xsl:text>http://help.yandex.ru/mail/?id=1124708</xsl:text>
    </xsl:variable>

    <xsl:template match="message">
        <message type="mixed">
            <xsl:call-template name="message-header">
                <xsl:with-param name="subject">
                    <xsl:call-template name="i18n:calendar.todo-email.Todo-list">
                        <xsl:with-param name="todo-list-name" select="$todo-list-name"/>
                    </xsl:call-template>
                </xsl:with-param>
            </xsl:call-template>

            <part id="1" type="alternative">
                <part id="1_1" content-type="text/plain; charset=utf-8">
                    <xsl:call-template name="text-part-plain-local"/>
                </part>
                <part id="1_2" content-type="text/html; charset=utf-8">
                    <xsl:call-template name="text-part-html-local"/>
                </part>
                <part id="1_3" content-type="text/calendar; charset=utf-8; method=PUBLISH"><xsl:value-of select="ics" /></part>
            </part>
            <part id="2" content-type="application/ics;charset=utf-8" name="event.ics"><xsl:value-of select="ics" /></part>
        </message>
    </xsl:template>

    <!-- Plain part -->

    <xsl:template name="text-part-plain-local">
        <xsl:call-template name="i18n:calendar.todo-email.You-were-sent-a-todo-list"/>
        <xsl:text>:</xsl:text>
        <xsl:text>.&lf;&lf;</xsl:text>

        <xsl:value-of select="$todo-list-name"/>
        <xsl:text>:&lf;</xsl:text>
        <xsl:apply-templates select="todo-items/todo-item" mode="plain"/>
        <xsl:text>&lf;</xsl:text>

        <xsl:call-template name="i18n:calendar.todo-email.Learn-about-todo-lists"/>
        <xsl:text>&lf;&lf;</xsl:text>

    </xsl:template>

    <xsl:template match="todo-item" mode="plain">
        <xsl:text>&nbsp;&bullet;&nbsp;</xsl:text>
        <xsl:value-of select="title"/>
        <xsl:text>&lf;</xsl:text>
    </xsl:template>

    <!-- Html part -->

    <xsl:template name="text-part-html-local">
        <html>
            <head>
                <meta http-equiv="Content-type" content="text/html; charset=utf-8" />
            </head>
            <body>
                <xsl:call-template name="text-part-html-body"/>
            </body>
        </html>
    </xsl:template>

    <xsl:template name="text-part-html-body">
        <p>
            <font face="Arial" size="3" color="#999999">
                <xsl:call-template name="i18n:calendar.todo-email.You-were-sent-a-todo-list"/>
                <xsl:text>:</xsl:text>
            </font>
        </p>
        <table width="100%" cellspacing="0" cellpadding="0" bgcolor="#f3f5f8">
            <tr>
                <td width="15"/>
                <td width="60"/>
                <td/>
                <td width="60"/>
                <td width="15"/>
            </tr>
            <tr>
                <td bgcolor="#3d8ed2" height="2" colspan="5"/>
            </tr>
            <tr>
                <td height="10" colspan="5"/>
            </tr>
            <tr>
                <td width="75" colspan="2"/>
                <td>
                    <h4 style="font-size: 100%; margin-bottom: 0.5em;">
                        <font face="Arial" size="4">
                            <b><xsl:value-of select="$todo-list-name"/></b>
                        </font>
                    </h4>
                    <ul style="padding: 0 0 0 15px; line-height: 1.5;">
                        <xsl:apply-templates select="todo-items/todo-item" mode="html"/>
                    </ul>
                </td>
                <td width="75" colspan="2"/>
            </tr>
            <tr>
                <td height="10" colspan="5"/>
            </tr>
            <tr>
                <td height="2" bgcolor="#3d8ed2" colspan="5"/>
            </tr>
            <tr>
                <td height="8" colspan="5"/>
            </tr>
            <tr>
                <!-- should be replaced somehow with widget in yandex mail -->
                <td width="15"/>
                <td colspan="3">
                    <font face="Arial" size="3">
                        <b>
                            <xsl:call-template name="i18n:calendar.todo-email.Learn-about-todo-lists"/>
                            <xsl:text> </xsl:text>
                            <a href="{$todo-service-link}">
                                <xsl:call-template name="i18n:calendar.todo-email.Todo-details-link"/>
                            </a>
                        </b>
                    </font>
                </td>
                <td width="15"/>
            </tr>
            <tr>
                <td height="10" colspan="5"/>
            </tr>
        </table>
    </xsl:template>

    <xsl:template match="todo-item" mode="html">
        <li>
            <font face="Arial" size="3">
                <xsl:value-of select="title"/>
            </font>
        </li>
    </xsl:template>

</xsl:stylesheet>

<!-- vim: set encoding=utf-8 ts=4 sw=4 et: -->
