<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet [
        <!ENTITY quot   "&#34;">
        <!ENTITY laquo  "&#171;">
        <!ENTITY raquo  "&#187;">
        <!ENTITY nbsp   "&#160;">
        <!ENTITY copy   "&#169;">
        <!ENTITY rarr   "&#8594;">
        <!ENTITY larr   "&#8592;">
        <!ENTITY hellip "&#8230;">
        <!ENTITY mdash  "&#8212;">
        <!ENTITY copy   "&#169;">
        <!ENTITY lf     "&#x0A;">
        <!ENTITY bullet "&#8226;">
        ]>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:math="http://exslt.org/math"
                xmlns:date="http://exslt.org/dates-and-times"
                xmlns:func="http://exslt.org/functions"
                xmlns:exsl="http://exslt.org/common"
                extension-element-prefixes="exsl math date func"
                xmlns:i18n="urn:yandex-functions:internationalization"
                version="1.0">

    <xsl:import href="email-xslts/common-event.xsl" />
    <xsl:output method="html" indent="no"/>


    <xsl:template match="message">
        <message type="alternative">
            <xsl:call-template name="message-header">
                <xsl:with-param name="subject">
                    <xsl:call-template name="subject"/>
                </xsl:with-param>
            </xsl:call-template>

            <part id="1" content-type="text/plain; charset=utf-8">
                <xsl:call-template name="text-part-plain-common"/>
            </part>
            <part id="2" content-type="text/html; charset=utf-8">
                <xsl:call-template name="text-part-html-common"/>
            </part>
        </message>
    </xsl:template>

    <xsl:variable name="type" select="message/type"/>

    <xsl:variable name="items-count-pluralized">
        <xsl:variable name="count" select="count(message/todo-items/todo-item)"/>

        <xsl:call-template name="i18n:tanker.dynamic.plural">
            <xsl:with-param name="count" select="$count"/>

            <xsl:with-param name="one">
                <xsl:call-template name="i18n:calendar.emails2.Todos-count-one">
                    <xsl:with-param name="count" select="$count"/>
                </xsl:call-template>
            </xsl:with-param>

            <xsl:with-param name="some">
                <xsl:call-template name="i18n:calendar.emails2.Todos-count-some">
                    <xsl:with-param name="count" select="$count"/>
                </xsl:call-template>
            </xsl:with-param>

            <xsl:with-param name="many">
                <xsl:call-template name="i18n:calendar.emails2.Todos-count-many">
                    <xsl:with-param name="count" select="$count"/>
                </xsl:call-template>
            </xsl:with-param>
        </xsl:call-template>
    </xsl:variable>

    <xsl:template name="subject">
        <xsl:if test="$type = 'planned'">
            <xsl:call-template name="i18n:calendar.emails2.Todo-planned-reminder-subject">
                <xsl:with-param name="when">
                    <xsl:call-template name="when-full"/>
                </xsl:with-param>
                <xsl:with-param name="lists">
                    <xsl:for-each select="todo-lists/todo-list">
                        <xsl:if test="position() &gt; 1"><xsl:text>, </xsl:text></xsl:if>
                        <xsl:text>«</xsl:text>
                        <xsl:value-of select="title"/>
                        <xsl:text>»</xsl:text>
                    </xsl:for-each>
                </xsl:with-param>
            </xsl:call-template>
        </xsl:if>
        <xsl:if test="$type = 'expired'">
            <xsl:call-template name="i18n:calendar.emails2.Todo-expired-reminder-subject">
                <xsl:with-param name="when">
                    <xsl:call-template name="when-full"/>
                </xsl:with-param>
                <xsl:with-param name="todos-count" select="$items-count-pluralized"/>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>

    <xsl:template name="message">
        <xsl:if test="$type = 'planned'">
            <xsl:call-template name="i18n:calendar.emails2.Todo-planned-reminder">
                <xsl:with-param name="when">
                    <xsl:call-template name="when-full"/>
                </xsl:with-param>
            </xsl:call-template>
        </xsl:if>
        <xsl:if test="$type = 'expired'">
            <xsl:call-template name="i18n:calendar.emails2.Todo-expired-reminder">
                <xsl:with-param name="when">
                    <xsl:call-template name="when-full"/>
                </xsl:with-param>
                <xsl:with-param name="todos-count" select="$items-count-pluralized"/>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>

    <xsl:template name="todo-link">
        <xsl:variable name="query">
            <xsl:if test="$type = 'expired'">
                <xsl:value-of select="'?sidebar=todo&amp;sidebarTab=expired'"/>
            </xsl:if>
            <xsl:if test="$type = 'planned'">
                <xsl:value-of select="'?sidebar=todo'"/>
            </xsl:if>
        </xsl:variable>

        <xsl:call-template name="i18n:calendar.emails2.Todo-reminder-link">
            <xsl:with-param name="text">
                <a href="{concat($calendar-url, $query)}">
                    <xsl:call-template name="i18n:calendar.emails2.Todo-reminder-link-text"/>
                </a>
            </xsl:with-param>
        </xsl:call-template>
    </xsl:template>

    <!-- Plain part -->

    <xsl:template name="text-part-plain-custom">
        <xsl:call-template name="message"/>
        <xsl:text>&lf;</xsl:text>

        <xsl:apply-templates select="todo-items/todo-item" mode="plain"/>
    </xsl:template>

    <xsl:template match="todo-item" mode="plain">
        <xsl:text>&nbsp;&bullet;&nbsp;</xsl:text>
        <xsl:value-of select="title"/>
        <xsl:text>&lf;</xsl:text>
    </xsl:template>


    <!-- Html part -->

    <xsl:template name="text-part-html-custom">
        <table cellpadding="4" width="100%">
            <tr>
                <td colspan="3">
                    <font size="4" face="Arial,sans-serif">
                        <b>
                            <xsl:call-template name="message"/>
                        </b>
                    </font>
                </td>
            </tr>
            <tr>
                <td width="40" colspan="1"/>
                <td>
                    <ul style="padding: 0; margin: 0; line-height: 1.5;">
                        <xsl:apply-templates select="todo-items/todo-item" mode="html"/>
                    </ul>
                </td>
                <td width="40" colspan="1"/>
            </tr>
            <tr>
                <td colspan="3">
                    <xsl:call-template name="todo-link"/>
                </td>
            </tr>
        </table>
    </xsl:template>

    <xsl:template match="todo-item" mode="html">
        <li>
            <font face="Arial" size="3">
                <xsl:value-of select="title"/>
            </font>
        </li>
    </xsl:template>

</xsl:stylesheet>

<!-- vim: set encoding=utf-8 ts=4 sw=4 et: -->
