JUNIT5()

JDK_VERSION(11)

PEERDIR(
    mail/calendar/core/ut-library
    contrib/java/org/junit/jupiter/junit-jupiter-api
    contrib/java/org/junit/jupiter/junit-jupiter-engine
    contrib/java/org/junit/jupiter/junit-jupiter-params
    contrib/java/org/junit/vintage/junit-vintage-engine
    contrib/java/org/mockito/mockito-junit-jupiter
    contrib/java/io/cucumber/cucumber-java
    contrib/java/io/cucumber/cucumber-junit
    contrib/java/io/cucumber/cucumber-spring
    contrib/java/org/postgresql/postgresql/9.4.1209-ch28677-2
)

INCLUDE(${ARCADIA_ROOT}/mail/micronaut/dependency_versions.inc)

REQUIREMENTS(
    network:full
    sb_vault:CALENDAR_YT_STAFF_TOKEN_PATH=file:MAIL:calendar-staff-api-token
    sb_vault:CALENDAR_TVMTOOL_TOKEN_PATH=file:MAIL:calendar-tvmtool-token
)

TAG(ya:noretries ya:fat ya:force_sandbox ya:sandbox_coverage)
SIZE(LARGE)
NO_LINT()

JAVAC_FLAGS(
    -parameters
)

JVM_ARGS(
    -Xms256M
    -Xmx2G
    -Dfile.encoding=UTF-8
    -Djavax.xml.xpath.XPathFactory:http://java.sun.com/jaxp/xpath/dom=com.saxonica.config.ProfessionalXPathFactory
    -Dorg.joda.time.DateTimeZone.Provider=tzdata.Provider
    -Dyandex.environment.type=tests
    -Djava.net.preferIPv6Addresses=true
    -Djava.net.preferIPv4Stack=false
    -javaagent:${EA_ASYNC_AGENT_PATH}
)

ANNOTATION_PROCESSOR(
    lombok.launch.AnnotationProcessorHider$AnnotationProcessor
)

DATA(arcadia/mail/calendar/core/schema)

JAVA_SRCS(SRCDIR ${ARCADIA_ROOT}/mail/calendar/core/src/test-integration/java **/*)
JAVA_SRCS(RESOURCES SRCDIR ${ARCADIA_ROOT}/mail/calendar/core/schema **/*)
JAVA_SRCS(RESOURCES SRCDIR ${ARCADIA_ROOT}/mail/calendar/core/src/test-integration/resources **/*)
JAVA_SRCS(RESOURCES SRCDIR ${ARCADIA_ROOT}/mail/calendar/core/src/test/resources **/*)
JAVA_SRCS(RESOURCES SRCDIR ${ARCADIA_ROOT}/mail/calendar/package/properties **/*)
JAVA_SRCS(RESOURCES SRCDIR ${ARCADIA_ROOT}/mail/calendar/package/logconfig **/log4j.xml)

IF (SANITIZER_TYPE)
    TAG(ya:not_autocheck)
ENDIF()

END()
