JAVA_PROGRAM(calendar)

JDK_VERSION(11)

SET(
    WSDL_ARGS
    -Dorg.apache.cxf.bus.factory=org.apache.cxf.bus.CXFBusFactory
)

JAVAC_FLAGS(
    -parameters
)

RUN_JAVA_PROGRAM(
    ${WSDL_ARGS}
    org.apache.cxf.tools.wsdlto.WSDLToJava -client -verbose -d ${BINDIR}/generated/wsdl wsdl/NotificationService.wsdl
    IN wsdl/NotificationService.wsdl
    OUT_DIR ${BINDIR}/generated/wsdl
    CLASSPATH mail/calendar/core/generate_wsdl
)

RUN_JAVA_PROGRAM(
    ${WSDL_ARGS}
    org.apache.cxf.tools.wsdlto.WSDLToJava -client -verbose -d ${BINDIR}/generated/wsdl wsdl/Services2010.wsdl
    IN wsdl/Services2010.wsdl
    OUT_DIR ${BINDIR}/generated/wsdl
    CLASSPATH mail/calendar/core/generate_wsdl
)

RUN_JAVA_PROGRAM(
    ru.yandex.calendar.genversion.GenVersion mail/calendar ${BINDIR}/generated/ver calendar-version.properties
    OUT_DIR ${BINDIR}/generated/ver
    CLASSPATH mail/java/generate_version
)

RUN_JAVA_PROGRAM(
    ru.yandex.calendar.generate.GenerateDb ${CURDIR}/schema/calendardb/migrations ${BINDIR}/generated/db
    IN_DIR schema/calendardb/migrations
    OUT_DIR ${BINDIR}/generated/db
    CLASSPATH mail/calendar/core/generate_db
)

# temporarly disabled tanker updated due to issue https://st.yandex-team.ru/TANKERMIGRATION-431
# IF (RELEASE)
#     RUN_JAVA_PROGRAM(
#         -Djava.net.preferIPv6Addresses=true
#         -Djava.net.preferIPv4Stack=false
#         ru.yandex.calendar.generate.DownloadTanker ${BINDIR}/generated/tanker/i18n
#         OUT_DIR ${BINDIR}/generated/tanker
#         CLASSPATH mail/calendar/core/download_tanker
#     )
# ENDIF()

LINT(strict)

SET(SPRING_VERSION 5.2.3.RELEASE)
SET(NETTY_VERSION 4.1.47.Final)
SET(JETTY_VERSION 9.4.45.v20220203)
SET(JACKSON_VERSION 2.10.1)

DEPENDENCY_MANAGEMENT(
    contrib/java/org/springframework/spring-beans/${SPRING_VERSION}
    contrib/java/org/springframework/spring-context/${SPRING_VERSION}
    contrib/java/org/springframework/spring-core/${SPRING_VERSION}
    contrib/java/org/springframework/spring-jdbc/${SPRING_VERSION}
    contrib/java/org/springframework/spring-test/${SPRING_VERSION}
    contrib/java/org/springframework/spring-tx/${SPRING_VERSION}
    contrib/java/org/springframework/spring-web/${SPRING_VERSION}
    contrib/java/org/springframework/spring-aop/${SPRING_VERSION}
    contrib/java/org/springframework/spring-context-support/${SPRING_VERSION}
)

PEERDIR(
    mail/java/tvmlocal
    mail/calendar/micro_core

    iceberg/bolts
    iceberg/commune
    iceberg/commune-a3
    iceberg/commune-a3-admin
    iceberg/commune-admin
    iceberg/commune-admin-all
    iceberg/commune-alive
    iceberg/commune-bazinga
    iceberg/commune-bazinga-pg
    iceberg/commune-db
    iceberg/commune-dynproperties
    iceberg/commune-graphite
    iceberg/commune-jparsec
    iceberg/commune-json
    iceberg/commune-holidays
    iceberg/commune-mail
    iceberg/commune-mail-framework
    iceberg/commune-monica
    iceberg/commune-object-printer
    iceberg/commune-random
    iceberg/commune-rpc
    iceberg/commune-script
    iceberg/commune-universal-object-parser
    iceberg/commune-web
    iceberg/commune-xml-or-json
    iceberg/commune-zk
    iceberg/commune-zk-admin
    iceberg/inside-agave
    iceberg/inside-captcha
    iceberg/inside-center
    iceberg/inside-client-utils
    iceberg/inside-conductor
    iceberg/inside-geobase
    iceberg/inside-logbroker
    iceberg/inside-passport
    library/java/tvmauth
    iceberg/misc
    iceberg/misc-apache-http-client-4
    iceberg/misc-bender
    iceberg/misc-bender-annotations
    iceberg/misc-cache
    iceberg/misc-db
    iceberg/misc-jetty
    iceberg/misc-http-client-common
    iceberg/misc-main
    iceberg/misc-pg-embedded
    iceberg/misc-spring
    iceberg/misc-translit
    iceberg/misc-xml
    iceberg/misc-worker

    contrib/java/com/fasterxml/jackson/core/jackson-core/${JACKSON_VERSION}
    contrib/java/com/fasterxml/jackson/core/jackson-databind/${JACKSON_VERSION}
    contrib/java/com/fasterxml/jackson/core/jackson-annotations/${JACKSON_VERSION}
    contrib/java/com/fasterxml/jackson/datatype/jackson-datatype-joda/${JACKSON_VERSION}
    contrib/java/com/fasterxml/jackson/datatype/jackson-datatype-jdk8/${JACKSON_VERSION}
    contrib/java/com/fasterxml/jackson/module/jackson-module-parameter-names/${JACKSON_VERSION}

    contrib/java/org/springframework/spring-beans
    contrib/java/org/springframework/spring-context
    contrib/java/org/springframework/spring-core
    contrib/java/org/springframework/spring-jdbc
    contrib/java/org/springframework/spring-test
    contrib/java/org/springframework/spring-tx
    contrib/java/org/springframework/spring-web
    contrib/java/org/springframework/spring-aop
    contrib/java/org/springframework/spring-context-support

    contrib/java/org/mnode/ical4j/ical4j/3.0.9
    contrib/java/backport-util-concurrent/backport-util-concurrent/3.1
    contrib/java/javax/cache/cache-api/1.1.0

    contrib/java/org/apache/jackrabbit/jackrabbit-webdav/2.1.2
    contrib/java/org/apache/jackrabbit/jackrabbit-jcr-commons/2.1.2

    contrib/java/org/apache/cxf/cxf-rt-transports-http/2.2.10
    contrib/java/org/apache/cxf/cxf-rt-frontend-simple/2.2.10
    contrib/java/org/apache/cxf/cxf-rt-bindings-soap/2.2.10
    contrib/java/org/apache/cxf/cxf-rt-databinding-jaxb/2.2.10
    contrib/java/org/apache/cxf/cxf-rt-core/2.2.10
    contrib/java/org/apache/cxf/cxf-tools-common/2.2.10
    contrib/java/org/apache/cxf/cxf-api/2.2.10
    contrib/java/org/apache/cxf/cxf-common-utilities/2.2.10
    contrib/java/org/apache/cxf/cxf-rt-frontend-jaxws/2.2.10
    contrib/java/org/apache/cxf/cxf-rt-ws-addr/2.2.10
    contrib/java/org/apache/cxf/cxf-tools-validator/2.2.10
    contrib/java/org/apache/cxf/cxf-tools-wsdlto-core/2.2.10
    contrib/java/org/apache/cxf/cxf-tools-wsdlto-frontend-jaxws/2.2.10
    contrib/java/org/apache/cxf/cxf-tools-wsdlto-databinding-jaxb/2.2.10

    contrib/java/com/google/code/gson/gson/2.3.1

    contrib/java/org/mozilla/universalchardet/1.0.3

    contrib/java/org/apache/commons/commons-lang3/3.4

    contrib/java/com/sun/xml/messaging/saaj/saaj-impl/1.3.4
    contrib/java/xerces/xercesImpl/2.11.0
    contrib/java/commons-lang/commons-lang/2.6
    contrib/java/javax/servlet/javax.servlet-api/3.1.0
    contrib/java/javax/mail/mail/1.4.3
    contrib/java/net/sf/saxon/saxonpe/9.2.0.6
    contrib/java/org/postgresql/postgresql/9.4.1209-ch28677-2
    contrib/java/org/slf4j/slf4j-log4j12/1.7.26
    contrib/java/org/slf4j/slf4j-api/1.7.26

    contrib/java/joda-time/joda-time/2.10.13
    contrib/java/joda-time/tzdata/2018f+2016j

    contrib/java/commons-logging/commons-logging/1.1.3

    contrib/java/org/codehaus/woodstox/stax2-api/3.1.4

    contrib/java/io/netty/netty-all/${NETTY_VERSION}
    contrib/java/io/netty/netty-buffer/${NETTY_VERSION}
    contrib/java/io/netty/netty-codec-dns/${NETTY_VERSION}
    contrib/java/io/netty/netty-codec-http/${NETTY_VERSION}
    contrib/java/io/netty/netty-codec/${NETTY_VERSION}
    contrib/java/io/netty/netty-common/${NETTY_VERSION}
    contrib/java/io/netty/netty-handler/${NETTY_VERSION}
    contrib/java/io/netty/netty-resolver-dns/${NETTY_VERSION}
    contrib/java/io/netty/netty-resolver/${NETTY_VERSION}
    contrib/java/io/netty/netty-transport/${NETTY_VERSION}
    contrib/java/io/netty/netty-transport-native-epoll/${NETTY_VERSION}
    contrib/java/io/netty/netty-codec-socks/${NETTY_VERSION}
    contrib/java/io/netty/netty-handler-proxy/${NETTY_VERSION}

    contrib/java/org/eclipse/jetty/jetty-plus/${JETTY_VERSION}

    contrib/java/commons-httpclient/commons-httpclient/3.1
    contrib/java/commons-io/commons-io/2.4
    contrib/java/org/easymock/easymock/3.4
    contrib/java/org/hamcrest/hamcrest-core/1.1
    contrib/java/org/projectlombok/lombok/1.18.22

    mail/java/oauth
    mail/java/bazinga_workers
    contrib/java/one/util/streamex/0.7.2

    kinopoisk/libs/java/micrometer-registry-yasm

    contrib/java/com/sun/xml/ws/jaxws-ri/2.3.0
    contrib/java/javax/validation/validation-api/2.0.1.Final

    contrib/java/junit/junit/4.13.2
)

ANNOTATION_PROCESSOR(
    lombok.launch.AnnotationProcessorHider$AnnotationProcessor
)

EXCLUDE(
    contrib/java/io/netty/netty-transport-native-epoll-linux-x86_64
    contrib/java/io/netty/netty-transport-native-kqueue-osx-x86_64
    contrib/java/io/netty/netty-transport-native-unix-common
    contrib/java/idea-annotations/idea-annotations
    contrib/java/javax/servlet/javax.servlet-api
    contrib/java/org/slf4j/jcl-over-slf4j
    contrib/java/net/sf/saxon/saxonhe
    contrib/java/org/apache/logging
    contrib/java/org/codehaus/woodstox/wstx-asl
    contrib/java/org/apache/geronimo
    contrib/java/org/apache/cxf/cxf-rt-bindings-xml
    contrib/java/org/apache/cxf/cxf-common-schemas
    contrib/java/org/jvnet/mimepull
    contrib/java/org/apache/ws/commons/axiom/axiom-api
    contrib/java/org/apache/ws/commons/axiom/axiom-impl
    contrib/java/asm/asm
    contrib/java/javax/servlet/servlet-api
    contrib/java/org/mongodb/mongo-java-driver/2.13.0
    contrib/java/org/codehaus/woodstox/woodstox-core-asl/4.4.1
    contrib/java/io/netty/netty-codec-socks/4.1.33.Final
    contrib/java/io/netty/netty-handler-proxy/4.1.33.Final
    contrib/java/javax/activation/activation/1.1
    contrib/java/com/sun/xml/bind/jaxb-impl/2.1.13
    contrib/java/com/sun/xml/txw2/txw2/20110809
    contrib/java/com/sun/xml/bind/jaxb-xjc/2.1.13
    contrib/java/javax/xml/soap/saaj-api
    contrib/java/xml-apis/xml-apis/1.4.01
    contrib/java/org/springframework/spring-jcl
)

JAVA_SRCS(SRCDIR src/main/java **/*)

JAVA_SRCS(RESOURCES SRCDIR ${ARCADIA_ROOT}/mail/calendar/core/src/main/resources **/*)

# temporarly disabled tanker updated due to issue https://st.yandex-team.ru/TANKERMIGRATION-431
# IF (RELEASE)
#     JAVA_SRCS(SRCDIR ${BINDIR}/generated/tanker **/*)
# ELSE()
#     JAVA_SRCS(SRCDIR ${ARCADIA_ROOT}/mail/calendar/core/target/downloaded **/*)
# ENDIF()
JAVA_SRCS(SRCDIR ${ARCADIA_ROOT}/mail/calendar/core/target/downloaded **/*)

JAVA_SRCS(SRCDIR ${ARCADIA_ROOT}/mail/calendar/core/wsdl **/*)
JAVA_SRCS(
    SRCDIR ${BINDIR}/generated/ver **/calendar-version.properties
    PACKAGE_PREFIX ru.yandex.calendar
)

JAVA_SRCS(
    SRCDIR ${BINDIR}/generated/db **/*
    PACKAGE_PREFIX ru.yandex.calendar.logic.beans.generated
)
JAVA_SRCS(SRCDIR ${BINDIR}/generated/wsdl **/*)
CHECK_JAVA_DEPS(yes)

IF (RELEASE)
    REQUIREMENTS(network:full)
ENDIF()

END()

RECURSE(
    download_tanker
    generate_db
)

RECURSE_FOR_TESTS(
    ut
    ut-small
    ut-integration
    ut-random
)
