package ru.yandex.calendar.ammo

import java.net.URI

data class ProcessedRequest(
    val uri: URI,
    val method: String = "GET",
    val headers: Map<String, String> = mapOf(),
    val body: String? = null,
    val tag: String? = uri.rawPath,
)

interface RequestProcessor {

    fun process(request: ParsedRequest): ProcessedRequest?
}

class WebReadOnlyProcessor : RequestProcessor {

    override fun process(request: ParsedRequest): ProcessedRequest? {
        if (request.body.isNotEmpty() && request.body != "{}") {
            return null
        }
        if (!request.uri.path.contains("get-") && !request.uri.path.contains("find-")) {
            return null
        }
        return ProcessedRequest(request.uri)
    }
}

class WebOmitIcsUrlProcessor : RequestProcessor {

    override fun process(request: ParsedRequest): ProcessedRequest? {
        if (request.uri.path.contains("IcsUrl")) {
            return null
        }
        if (request.body.isNotEmpty() && !request.body.startsWith("{")) {
            return null
        }
        return if (request.body.isEmpty() || request.body == "{}") {
            ProcessedRequest(
                uri = request.uri,
                method = "GET",
            )
        } else {
            ProcessedRequest(
                uri = request.uri,
                method = "POST",
                body = request.body,
            )
        }
    }
}
